/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.Template;
import com.ptteng.muscle.main.service.TemplateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateServiceImpl
extends BaseDaoServiceImpl
implements TemplateService {
    private static final Log log = LogFactory.getLog(TemplateServiceImpl.class);

    public Long insert(Template template) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + template));
        if (template == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        template.setCreateAt(Long.valueOf(currentTimeMillis));
        template.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)template);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + template));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Template> insertList(List<Template> templateList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (templateList == null ? "null" : Integer.valueOf(templateList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(templateList)) {
            return new ArrayList<Template>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Template template : templateList) {
            template.setCreateAt(Long.valueOf(currentTimeMillis));
            template.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(templateList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + templateList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Template.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Template template) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (template == null ? "null" : template.getId())));
        boolean result = false;
        if (template == null) {
            return true;
        }
        template.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)template);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + template));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + template));
        }
        return result;
    }

    public boolean updateList(List<Template> templateList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (templateList == null ? "null" : Integer.valueOf(templateList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(templateList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Template template : templateList) {
            template.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(templateList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + templateList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + templateList.size()));
        return result;
    }

    public Template getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Template template = null;
        if (id == null) {
            return template;
        }
        try {
            template = (Template)this.dao.get(Template.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return template;
    }

    public List<Template> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List template = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Template>();
        }
        try {
            template = this.dao.getList(Template.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (template == null ? "null" : Integer.valueOf(template.size()))));
        return template;
    }

    public List<Long> getTemplateIdsByDidOrderByTemplateAt(Long did, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by did,start,limit  : " + did + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTemplateIdsByDidOrderByTemplateAt", new Object[]{did}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by did,start,limit)  : " + did + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTemplateIdsByDidOrderByTemplateAt(Long did) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by did  : " + did));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTemplateIdsByDidOrderByTemplateAt", new Object[]{did});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by did)  : " + did));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getTemplateIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTemplateIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTemplateIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTemplateIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTemplateIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

