/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.ProgramRelation;
import com.ptteng.muscle.main.service.ProgramRelationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgramRelationServiceImpl
extends BaseDaoServiceImpl
implements ProgramRelationService {
    private static final Log log = LogFactory.getLog(ProgramRelationServiceImpl.class);

    public Long insert(ProgramRelation programRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + programRelation));
        if (programRelation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        programRelation.setCreateAt(Long.valueOf(currentTimeMillis));
        programRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)programRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + programRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ProgramRelation> insertList(List<ProgramRelation> programRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (programRelationList == null ? "null" : Integer.valueOf(programRelationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(programRelationList)) {
            return new ArrayList<ProgramRelation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProgramRelation programRelation : programRelationList) {
            programRelation.setCreateAt(Long.valueOf(currentTimeMillis));
            programRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(programRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + programRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ProgramRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ProgramRelation programRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (programRelation == null ? "null" : programRelation.getId())));
        boolean result = false;
        if (programRelation == null) {
            return true;
        }
        programRelation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)programRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + programRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + programRelation));
        }
        return result;
    }

    public boolean updateList(List<ProgramRelation> programRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (programRelationList == null ? "null" : Integer.valueOf(programRelationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(programRelationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProgramRelation programRelation : programRelationList) {
            programRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(programRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + programRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + programRelationList.size()));
        return result;
    }

    public ProgramRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ProgramRelation programRelation = null;
        if (id == null) {
            return programRelation;
        }
        try {
            programRelation = (ProgramRelation)this.dao.get(ProgramRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return programRelation;
    }

    public List<ProgramRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List programRelation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProgramRelation>();
        }
        try {
            programRelation = this.dao.getList(ProgramRelation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (programRelation == null ? "null" : Integer.valueOf(programRelation.size()))));
        return programRelation;
    }

    public List<Long> getProgramRelationIdsByPidAndStatus(Long pid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,status,start,limit  : " + pid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgramRelationIdsByPidAndStatus", new Object[]{pid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,status,start,limit)  : " + pid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProgramRelationIdsByPidAndDid(Long pid, Long did, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,did,start,limit  : " + pid + " , " + did + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgramRelationIdsByPidAndDid", new Object[]{pid, did}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,did,start,limit)  : " + pid + " , " + did + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProgramRelationIdsByPidAndStatusOrderByBuyAt(Long pid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,status,start,limit  : " + pid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgramRelationIdsByPidAndStatusOrderByBuyAt", new Object[]{pid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,status,start,limit)  : " + pid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProgramRelationIdsByPidAndStatus(Long pid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by pid,status  : " + pid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProgramRelationIdsByPidAndStatus", new Object[]{pid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by pid,status)  : " + pid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProgramRelationIdsByPidAndDid(Long pid, Long did) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by pid,did  : " + pid + " , " + did));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProgramRelationIdsByPidAndDid", new Object[]{pid, did});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by pid,did)  : " + pid + " , " + did));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProgramRelationIdsByPidAndStatusOrderByBuyAt(Long pid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by pid,status  : " + pid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProgramRelationIdsByPidAndStatusOrderByBuyAt", new Object[]{pid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by pid,status)  : " + pid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProgramRelationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProgramRelationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProgramRelationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProgramRelationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProgramRelationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

