/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.Patient;
import com.ptteng.muscle.main.service.PatientService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatientServiceImpl
extends BaseDaoServiceImpl
implements PatientService {
    private static final Log log = LogFactory.getLog(PatientServiceImpl.class);

    public Long insert(Patient patient) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + patient));
        if (patient == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        patient.setCreateAt(Long.valueOf(currentTimeMillis));
        patient.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)patient);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + patient));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Patient> insertList(List<Patient> patientList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (patientList == null ? "null" : Integer.valueOf(patientList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(patientList)) {
            return new ArrayList<Patient>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Patient patient : patientList) {
            patient.setCreateAt(Long.valueOf(currentTimeMillis));
            patient.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(patientList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + patientList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Patient.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Patient patient) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (patient == null ? "null" : patient.getId())));
        boolean result = false;
        if (patient == null) {
            return true;
        }
        patient.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)patient);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + patient));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + patient));
        }
        return result;
    }

    public boolean updateList(List<Patient> patientList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (patientList == null ? "null" : Integer.valueOf(patientList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(patientList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Patient patient : patientList) {
            patient.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(patientList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + patientList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + patientList.size()));
        return result;
    }

    public Patient getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Patient patient = null;
        if (id == null) {
            return patient;
        }
        try {
            patient = (Patient)this.dao.get(Patient.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return patient;
    }

    public List<Patient> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List patient = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Patient>();
        }
        try {
            patient = this.dao.getList(Patient.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (patient == null ? "null" : Integer.valueOf(patient.size()))));
        return patient;
    }

    public List<Long> getPatientIdsByDid(Long did, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by did,start,limit  : " + did + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPatientIdsByDid", new Object[]{did}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by did,start,limit)  : " + did + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPatientIdsByDid(Long did) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by did  : " + did));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPatientIdsByDid", new Object[]{did});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by did)  : " + did));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPatientIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPatientIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPatientIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPatientIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPatientIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

