/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.Hospital;
import com.ptteng.muscle.main.service.HospitalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HospitalServiceImpl
extends BaseDaoServiceImpl
implements HospitalService {
    private static final Log log = LogFactory.getLog(HospitalServiceImpl.class);

    public Long insert(Hospital hospital) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + hospital));
        if (hospital == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        hospital.setCreateAt(Long.valueOf(currentTimeMillis));
        hospital.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)hospital);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + hospital));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Hospital> insertList(List<Hospital> hospitalList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (hospitalList == null ? "null" : Integer.valueOf(hospitalList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(hospitalList)) {
            return new ArrayList<Hospital>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Hospital hospital : hospitalList) {
            hospital.setCreateAt(Long.valueOf(currentTimeMillis));
            hospital.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(hospitalList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + hospitalList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Hospital.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Hospital hospital) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (hospital == null ? "null" : hospital.getId())));
        boolean result = false;
        if (hospital == null) {
            return true;
        }
        hospital.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)hospital);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + hospital));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + hospital));
        }
        return result;
    }

    public boolean updateList(List<Hospital> hospitalList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (hospitalList == null ? "null" : Integer.valueOf(hospitalList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(hospitalList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Hospital hospital : hospitalList) {
            hospital.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(hospitalList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + hospitalList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + hospitalList.size()));
        return result;
    }

    public Hospital getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Hospital hospital = null;
        if (id == null) {
            return hospital;
        }
        try {
            hospital = (Hospital)this.dao.get(Hospital.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return hospital;
    }

    public List<Hospital> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List hospital = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Hospital>();
        }
        try {
            hospital = this.dao.getList(Hospital.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (hospital == null ? "null" : Integer.valueOf(hospital.size()))));
        return hospital;
    }

    public List<Long> getHospitalIdsByCidAndGradeOrderByTotal(Long cid, Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cid,grade,start,limit  : " + cid + " , " + grade + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getHospitalIdsByCidAndGradeOrderByTotal", new Object[]{cid, grade}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cid,grade,start,limit)  : " + cid + " , " + grade + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countHospitalIdsByCidAndGradeOrderByTotal(Long cid, Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by cid,grade  : " + cid + " , " + grade));
        }
        Integer count = null;
        try {
            count = this.dao.count("getHospitalIdsByCidAndGradeOrderByTotal", new Object[]{cid, grade});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by cid,grade)  : " + cid + " , " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getHospitalIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getHospitalIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countHospitalIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getHospitalIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getHospitalIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

