/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.Equipment;
import com.ptteng.muscle.main.service.EquipmentService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquipmentServiceImpl
extends BaseDaoServiceImpl
implements EquipmentService {
    private static final Log log = LogFactory.getLog(EquipmentServiceImpl.class);

    public Long insert(Equipment equipment) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + equipment));
        if (equipment == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        equipment.setCreateAt(Long.valueOf(currentTimeMillis));
        equipment.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)equipment);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + equipment));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Equipment> insertList(List<Equipment> equipmentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (equipmentList == null ? "null" : Integer.valueOf(equipmentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(equipmentList)) {
            return new ArrayList<Equipment>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Equipment equipment : equipmentList) {
            equipment.setCreateAt(Long.valueOf(currentTimeMillis));
            equipment.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(equipmentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + equipmentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Equipment.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Equipment equipment) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (equipment == null ? "null" : equipment.getId())));
        boolean result = false;
        if (equipment == null) {
            return true;
        }
        equipment.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)equipment);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + equipment));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + equipment));
        }
        return result;
    }

    public boolean updateList(List<Equipment> equipmentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (equipmentList == null ? "null" : Integer.valueOf(equipmentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(equipmentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Equipment equipment : equipmentList) {
            equipment.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(equipmentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + equipmentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + equipmentList.size()));
        return result;
    }

    public Equipment getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Equipment equipment = null;
        if (id == null) {
            return equipment;
        }
        try {
            equipment = (Equipment)this.dao.get(Equipment.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return equipment;
    }

    public List<Equipment> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List equipment = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Equipment>();
        }
        try {
            equipment = this.dao.getList(Equipment.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (equipment == null ? "null" : Integer.valueOf(equipment.size()))));
        return equipment;
    }

    public List<Long> getEquipmentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getEquipmentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countEquipmentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getEquipmentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getEquipmentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getEquipmentByDeviceToken(String device_token) throws ServiceException, ServiceDaoException {
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getEquipmentByDeviceToken", new Object[]{device_token});
            log.info((Object)("========get getEquipmentByModel id====" + id));
        }
        catch (DaoException e) {
            log.info((Object)"========get getEquipmentByModel id error========");
            e.printStackTrace();
        }
        return id;
    }
}

