/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.service.DoctorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DoctorServiceImpl
extends BaseDaoServiceImpl
implements DoctorService {
    private static final Log log = LogFactory.getLog(DoctorServiceImpl.class);

    public Long insert(Doctor doctor) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + doctor));
        if (doctor == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        doctor.setCreateAt(Long.valueOf(currentTimeMillis));
        doctor.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)doctor);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + doctor));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Doctor> insertList(List<Doctor> doctorList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (doctorList == null ? "null" : Integer.valueOf(doctorList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(doctorList)) {
            return new ArrayList<Doctor>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Doctor doctor : doctorList) {
            doctor.setCreateAt(Long.valueOf(currentTimeMillis));
            doctor.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(doctorList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + doctorList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Doctor.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Doctor doctor) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (doctor == null ? "null" : doctor.getId())));
        boolean result = false;
        if (doctor == null) {
            return true;
        }
        doctor.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)doctor);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + doctor));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + doctor));
        }
        return result;
    }

    public boolean updateList(List<Doctor> doctorList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (doctorList == null ? "null" : Integer.valueOf(doctorList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(doctorList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Doctor doctor : doctorList) {
            doctor.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(doctorList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + doctorList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + doctorList.size()));
        return result;
    }

    public Doctor getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Doctor doctor = null;
        if (id == null) {
            return doctor;
        }
        try {
            doctor = (Doctor)this.dao.get(Doctor.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return doctor;
    }

    public List<Doctor> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List doctor = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Doctor>();
        }
        try {
            doctor = this.dao.getList(Doctor.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (doctor == null ? "null" : Integer.valueOf(doctor.size()))));
        return doctor;
    }

    public List<Long> getDoctorIdsByCidOrderByAverage(Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cid,start,limit  : " + cid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDoctorIdsByCidOrderByAverage", new Object[]{cid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cid,start,limit)  : " + cid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getDoctorIdsByHidOrderByAverage(Long hid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by hid,start,limit  : " + hid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDoctorIdsByHidOrderByAverage", new Object[]{hid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by hid,start,limit)  : " + hid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDoctorIdsByCidOrderByAverage(Long cid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by cid  : " + cid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDoctorIdsByCidOrderByAverage", new Object[]{cid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by cid)  : " + cid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countDoctorIdsByHidOrderByAverage(Long hid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by hid  : " + hid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDoctorIdsByHidOrderByAverage", new Object[]{hid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by hid)  : " + hid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getDoctorIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDoctorIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDoctorIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDoctorIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDoctorIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

