/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.main.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.muscle.main.model.Daily;
import com.ptteng.muscle.main.service.DailyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DailyServiceImpl
extends BaseDaoServiceImpl
implements DailyService {
    private static final Log log = LogFactory.getLog(DailyServiceImpl.class);

    public Long insert(Daily daily) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + daily));
        if (daily == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        daily.setCreateAt(Long.valueOf(currentTimeMillis));
        daily.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)daily);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + daily));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Daily> insertList(List<Daily> dailyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (dailyList == null ? "null" : Integer.valueOf(dailyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(dailyList)) {
            return new ArrayList<Daily>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Daily daily : dailyList) {
            daily.setCreateAt(Long.valueOf(currentTimeMillis));
            daily.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(dailyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + dailyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Daily.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Daily daily) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (daily == null ? "null" : daily.getId())));
        boolean result = false;
        if (daily == null) {
            return true;
        }
        daily.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)daily);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + daily));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + daily));
        }
        return result;
    }

    public boolean updateList(List<Daily> dailyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (dailyList == null ? "null" : Integer.valueOf(dailyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(dailyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Daily daily : dailyList) {
            daily.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(dailyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + dailyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + dailyList.size()));
        return result;
    }

    public Daily getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Daily daily = null;
        if (id == null) {
            return daily;
        }
        try {
            daily = (Daily)this.dao.get(Daily.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return daily;
    }

    public List<Daily> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List daily = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Daily>();
        }
        try {
            daily = this.dao.getList(Daily.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (daily == null ? "null" : Integer.valueOf(daily.size()))));
        return daily;
    }

    public List<Long> getDailyIdsByPidOrderByTrainTime(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,start,limit  : " + pid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDailyIdsByPidOrderByTrainTime", new Object[]{pid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,start,limit)  : " + pid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDailyIdsByPidOrderByTrainTime(Long pid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by pid  : " + pid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDailyIdsByPidOrderByTrainTime", new Object[]{pid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by pid)  : " + pid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getDailyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDailyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDailyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDailyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDailyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

