/**
 * 
 */
package com.ptteng.sca.muscle.main.client;

import java.util.List;
import java.util.Map;

import com.ptteng.muscle.main.model.Patient;
import com.ptteng.muscle.main.service.PatientService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class PatientSCAClient implements PatientService {

    private PatientService patientService;

	public PatientService getPatientService() {
		return patientService;
	}
	
	
	public void setPatientService(PatientService patientService) {
		this.patientService =patientService;
	}
	
	
			   
		@Override
		public Long insert(Patient patient)throws ServiceException, ServiceDaoException{
		
		return patientService.insert(patient);
		          
		
		}	
		  
    	   
		@Override
		public List<Patient> insertList(List<Patient> patientList)throws ServiceException, ServiceDaoException{
		
		return patientService.insertList(patientList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return patientService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Patient patient)throws ServiceException, ServiceDaoException{
		
		return patientService.update(patient);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Patient> patientList)throws ServiceException, ServiceDaoException{
		
		return patientService.updateList(patientList);
		          
		
		}	
		  
    	   
		@Override
		public Patient getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return patientService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Patient> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return patientService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPatientIdsByDid(Long did,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return patientService.getPatientIdsByDid(did,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPatientIdsByDid(Long did)throws ServiceException, ServiceDaoException{
		
		return patientService.countPatientIdsByDid(did);
	
	
	}
	
		
	
		@Override
	public List<Long> getPatientIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return patientService.getPatientIds(start, limit);
	}

	@Override
	public Integer countPatientIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return patientService.countPatientIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return patientService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return patientService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   patientService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.patientService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

