/**
 * 
 */
package com.ptteng.sca.muscle.main.client;

import java.util.List;
import java.util.Map;

import com.ptteng.muscle.main.model.Hospital;
import com.ptteng.muscle.main.service.HospitalService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class HospitalSCAClient implements HospitalService {

    private HospitalService hospitalService;

	public HospitalService getHospitalService() {
		return hospitalService;
	}
	
	
	public void setHospitalService(HospitalService hospitalService) {
		this.hospitalService =hospitalService;
	}
	
	
			   
		@Override
		public Long insert(Hospital hospital)throws ServiceException, ServiceDaoException{
		
		return hospitalService.insert(hospital);
		          
		
		}	
		  
    	   
		@Override
		public List<Hospital> insertList(List<Hospital> hospitalList)throws ServiceException, ServiceDaoException{
		
		return hospitalService.insertList(hospitalList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return hospitalService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Hospital hospital)throws ServiceException, ServiceDaoException{
		
		return hospitalService.update(hospital);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Hospital> hospitalList)throws ServiceException, ServiceDaoException{
		
		return hospitalService.updateList(hospitalList);
		          
		
		}	
		  
    	   
		@Override
		public Hospital getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return hospitalService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Hospital> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return hospitalService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getHospitalIdsByCidAndGradeOrderByTotal(Long cid,Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return hospitalService.getHospitalIdsByCidAndGradeOrderByTotal(cid,grade,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countHospitalIdsByCidAndGradeOrderByTotal(Long cid,Integer grade)throws ServiceException, ServiceDaoException{
		
		return hospitalService.countHospitalIdsByCidAndGradeOrderByTotal(cid,grade);
	
	
	}
	
		
	
		@Override
	public List<Long> getHospitalIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return hospitalService.getHospitalIds(start, limit);
	}

	@Override
	public Integer countHospitalIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return hospitalService.countHospitalIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return hospitalService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return hospitalService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   hospitalService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.hospitalService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

