/**
 * 
 */
package com.ptteng.sca.muscle.main.client;

import java.util.List;
import java.util.Map;

import com.ptteng.muscle.main.model.Equipment;
import com.ptteng.muscle.main.service.EquipmentService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class EquipmentSCAClient implements EquipmentService {

    private EquipmentService equipmentService;

	public EquipmentService getEquipmentService() {
		return equipmentService;
	}
	
	
	public void setEquipmentService(EquipmentService equipmentService) {
		this.equipmentService =equipmentService;
	}
	
	
			   
		@Override
		public Long insert(Equipment equipment)throws ServiceException, ServiceDaoException{
		
		return equipmentService.insert(equipment);
		          
		
		}	
		  
    	   
		@Override
		public List<Equipment> insertList(List<Equipment> equipmentList)throws ServiceException, ServiceDaoException{
		
		return equipmentService.insertList(equipmentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return equipmentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Equipment equipment)throws ServiceException, ServiceDaoException{
		
		return equipmentService.update(equipment);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Equipment> equipmentList)throws ServiceException, ServiceDaoException{
		
		return equipmentService.updateList(equipmentList);
		          
		
		}	
		  
    	   
		@Override
		public Equipment getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return equipmentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Equipment> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return equipmentService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
		
	
	
    		
	
		@Override
	public List<Long> getEquipmentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentService.getEquipmentIds(start, limit);
	}

	@Override
	public Integer countEquipmentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentService.countEquipmentIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentService.fakeDelete(clz, id);
	}

	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   equipmentService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.equipmentService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Long getEquipmentByDeviceToken(String device_token) throws ServiceException, ServiceDaoException{

		return this.equipmentService.getEquipmentByDeviceToken(device_token);
	}
}

