/**
 * 
 */
package com.ptteng.sca.muscle.main.client;

import java.util.List;
import java.util.Map;

import com.ptteng.muscle.main.model.EquipmentRelation;
import com.ptteng.muscle.main.service.EquipmentRelationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class EquipmentRelationSCAClient implements EquipmentRelationService {

    private EquipmentRelationService equipmentRelationService;

	public EquipmentRelationService getEquipmentRelationService() {
		return equipmentRelationService;
	}
	
	
	public void setEquipmentRelationService(EquipmentRelationService equipmentRelationService) {
		this.equipmentRelationService =equipmentRelationService;
	}
	
	
			   
		@Override
		public Long insert(EquipmentRelation equipmentRelation)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.insert(equipmentRelation);
		          
		
		}	
		  
    	   
		@Override
		public List<EquipmentRelation> insertList(List<EquipmentRelation> equipmentRelationList)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.insertList(equipmentRelationList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(EquipmentRelation equipmentRelation)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.update(equipmentRelation);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<EquipmentRelation> equipmentRelationList)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.updateList(equipmentRelationList);
		          
		
		}	
		  
    	   
		@Override
		public EquipmentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<EquipmentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByEid(Long eid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.getUidsByEid(eid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getEquipmentRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.getEquipmentRelationIdsByUid(uid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getEquipmentRelationIdsByEid(Long eid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.getEquipmentRelationIdsByEid(eid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getEidsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.getEidsByUid(uid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByEid(Long eid)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.countUidsByEid(eid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countEquipmentRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.countEquipmentRelationIdsByUid(uid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countEquipmentRelationIdsByEid(Long eid)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.countEquipmentRelationIdsByEid(eid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countEidsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return equipmentRelationService.countEidsByUid(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getEquipmentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentRelationService.getEquipmentRelationIds(start, limit);
	}

	@Override
	public Integer countEquipmentRelationIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentRelationService.countEquipmentRelationIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentRelationService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return equipmentRelationService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   equipmentRelationService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.equipmentRelationService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}

	//根据uid 和 eid获取对应关系的id

	@Override
	public Long getEquipmentRelationByUidAndEid(Long uid,Long eid) throws ServiceException, ServiceDaoException{

		return this.equipmentRelationService.getEquipmentRelationByUidAndEid(uid, eid);
	}

}

