/**
 * 
 */
package com.ptteng.sca.muscle.main.client;

import java.util.List;
import java.util.Map;

import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.service.DoctorService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class DoctorSCAClient implements DoctorService {

    private DoctorService doctorService;

	public DoctorService getDoctorService() {
		return doctorService;
	}
	
	
	public void setDoctorService(DoctorService doctorService) {
		this.doctorService =doctorService;
	}
	
	
			   
		@Override
		public Long insert(Doctor doctor)throws ServiceException, ServiceDaoException{
		
		return doctorService.insert(doctor);
		          
		
		}	
		  
    	   
		@Override
		public List<Doctor> insertList(List<Doctor> doctorList)throws ServiceException, ServiceDaoException{
		
		return doctorService.insertList(doctorList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return doctorService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Doctor doctor)throws ServiceException, ServiceDaoException{
		
		return doctorService.update(doctor);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Doctor> doctorList)throws ServiceException, ServiceDaoException{
		
		return doctorService.updateList(doctorList);
		          
		
		}	
		  
    	   
		@Override
		public Doctor getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return doctorService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Doctor> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return doctorService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDoctorIdsByCidOrderByAverage(Long cid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return doctorService.getDoctorIdsByCidOrderByAverage(cid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDoctorIdsByHidOrderByAverage(Long hid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return doctorService.getDoctorIdsByHidOrderByAverage(hid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDoctorIdsByCidOrderByAverage(Long cid)throws ServiceException, ServiceDaoException{
		
		return doctorService.countDoctorIdsByCidOrderByAverage(cid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDoctorIdsByHidOrderByAverage(Long hid)throws ServiceException, ServiceDaoException{
		
		return doctorService.countDoctorIdsByHidOrderByAverage(hid);
	
	
	}
	
		
	
		@Override
	public List<Long> getDoctorIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return doctorService.getDoctorIds(start, limit);
	}

	@Override
	public Integer countDoctorIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return doctorService.countDoctorIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return doctorService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return doctorService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   doctorService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.doctorService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

