package com.ptteng.muscle.main.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.muscle.main.model.Patient;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface PatientService extends BaseDaoService {

	



   		   
		
		public Long insert(Patient patient)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Patient> insertList(List<Patient> patientList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Patient patient)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Patient> patientList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Patient getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Patient> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countPatientIdsByDid(Long did)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getPatientIdsByDid(Long did,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPatientIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPatientIds() throws ServiceException, ServiceDaoException;
	

}

