package com.ptteng.muscle.main.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.muscle.main.model.Hospital;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface HospitalService extends BaseDaoService {

	



   		   
		
		public Long insert(Hospital hospital)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Hospital> insertList(List<Hospital> hospitalList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Hospital hospital)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Hospital> hospitalList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Hospital getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Hospital> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countHospitalIdsByCidAndGradeOrderByTotal(Long cid,Integer grade)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getHospitalIdsByCidAndGradeOrderByTotal(Long cid,Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getHospitalIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countHospitalIds() throws ServiceException, ServiceDaoException;
	

}

