package com.ptteng.muscle.main.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.muscle.main.model.Equipment;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface EquipmentService extends BaseDaoService {


		
		public Long insert(Equipment equipment)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Equipment> insertList(List<Equipment> equipmentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Equipment equipment)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Equipment> equipmentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Equipment getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Equipment> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  

	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getEquipmentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countEquipmentIds() throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getEquipmentByDeviceToken(String device_token) throws ServiceException, ServiceDaoException;

}

