package com.ptteng.muscle.main.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.muscle.main.model.EquipmentRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface EquipmentRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(EquipmentRelation equipmentRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<EquipmentRelation> insertList(List<EquipmentRelation> equipmentRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(EquipmentRelation equipmentRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<EquipmentRelation> equipmentRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public EquipmentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<EquipmentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUidsByEid(Long eid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countEquipmentRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countEquipmentRelationIdsByEid(Long eid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countEidsByUid(Long uid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUidsByEid(Long eid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getEquipmentRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getEquipmentRelationIdsByEid(Long eid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getEidsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getEquipmentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countEquipmentRelationIds() throws ServiceException, ServiceDaoException;

	//根据uid 和 eid获取对应关系的id
	public Long getEquipmentRelationByUidAndEid(Long uid,Long eid) throws ServiceException, ServiceDaoException;
}

