package com.ptteng.muscle.main.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.muscle.main.model.Doctor;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface DoctorService extends BaseDaoService {

	



   		   
		
		public Long insert(Doctor doctor)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Doctor> insertList(List<Doctor> doctorList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Doctor doctor)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Doctor> doctorList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Doctor getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Doctor> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countDoctorIdsByCidOrderByAverage(Long cid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countDoctorIdsByHidOrderByAverage(Long hid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getDoctorIdsByCidOrderByAverage(Long cid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getDoctorIdsByHidOrderByAverage(Long hid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getDoctorIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDoctorIds() throws ServiceException, ServiceDaoException;
	

}

