package com.ptteng.muscle.main.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "apply")
public class Apply implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 202749643448521728L;

    /*3.申请状态
      0:申请中
      1:申请失败
      2:申请成功
      3:撤销申请*/
    public static final Integer IN_THE_APPLICATION = 0;
    public static final Integer APPLICATION_FAILED = 1;
    public static final Integer SUCCESSFUL_APPLICATIOIN = 2;
    public static final Integer REVOKE_THE_APPLICATION = 3;

    private Long id;


    private Long pid;


    private Long did;


    private Integer status;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "pid")
    public Long getPid() {
        return pid;
    }


    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Column(name = "did")
    public Long getDid() {
        return did;
    }


    public void setDid(Long did) {
        this.did = did;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
            return ToStringBuilder.reflectionToString(this,
                    ToStringStyle.MULTI_LINE_STYLE);
    }

}

