/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.message.etl.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getAllDoctor() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", 0);
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "doctor");
        return params;
    }

    public static Map<String, Object> getNotCertificationQuery() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status & in ", "(0,1,3,4)");
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "doctor");
        return params;
    }

    public static Map<String, Object> getCertificationQuery() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", 2);
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "doctor");
        return params;
    }

    public static Map<String, Object> getProgramByMobileQuery(Long uid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("pid", uid);
        }
        params.put("status", 1);
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "program_relation");
        return params;
    }

    public static Map<String, Object> getBloodFlowRQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "bloodFlow_report");
        return params;
    }

    public static Map<String, Object> getTemperatureChecksQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at");
        params.put("@query", "id");
        params.put("@table", "temperature_check");
        return params;
    }

    public static Map<String, Object> getTemperatureChecksStemQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at");
        params.put("@query", "id");
        params.put("@table", "temperature_check_stem");
        return params;
    }

    public static Map<String, Object> getSensitityQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "sensitivity_report");
        return params;
    }

    public static Map<String, Object> getHardessReportRootTQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "hardness_report_root");
        return params;
    }

    public static Map<String, Object> getHardessReportQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "hardness_report");
        return params;
    }

    public static Map<String, Object> getHardnessDetectionQuery(String time, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)time)) {
            params.put("detection_at & like", "'" + time + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "hardness_detection");
        return params;
    }

    public static Map<String, Object> getHardessQuery(StringBuffer hardessT, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String s = hardessT.toString();
        if (DataUtils.isNotNullOrEmpty((Object)s)) {
            params.put("detection_at & in ", "(" + s + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "rau ");
        params.put("@query", "id");
        params.put("@table", "hardness_report");
        return params;
    }

    public static Map<String, Object> getHardessTauQuery(StringBuffer hardessT, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String s = hardessT.toString();
        if (DataUtils.isNotNullOrEmpty((Object)s)) {
            params.put("detection_at & in ", "(" + s + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "tau ");
        params.put("@query", "id");
        params.put("@table", "hardness_report");
        return params;
    }

    public static Map<String, Object> getHardessReportRootQuery(StringBuffer hardessT, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String s = hardessT.toString();
        if (DataUtils.isNotNullOrEmpty((Object)s)) {
            params.put("detection_at & in ", "(" + s + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "rau_root ");
        params.put("@query", "id");
        params.put("@table", "hardness_report_root");
        return params;
    }

    public static Map<String, Object> getHardessReportRootTauQuery(StringBuffer hardessT, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String s = hardessT.toString();
        if (DataUtils.isNotNullOrEmpty((Object)s)) {
            params.put("detection_at & in ", "(" + s + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "tau_root ");
        params.put("@query", "id");
        params.put("@table", "hardness_report_root");
        return params;
    }

    public static Map<String, Object> getBloodFlowQuery(StringBuffer bloodFlowT, String mobile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String s = bloodFlowT.toString();
        if (DataUtils.isNotNullOrEmpty((Object)s)) {
            params.put("detection_at & in ", "(" + s + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'" + mobile + "'");
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "bloodFlow_report");
        return params;
    }

    public static Map<String, Object> getSensitityReportQuery(Long createFrom, Long createTo, String mobile, boolean isCount) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            param.put("mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createFrom)) {
            param.put("ins_at & >=", createFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createTo)) {
            param.put("ins_at & <=", createTo);
        }
        if (isCount) {
            param.put("@query", "count(id)");
        } else {
            param.put("@order", "ins_at desc");
            param.put("@query", "id");
        }
        param.put("@table", "sensitivity_report");
        return param;
    }

    public static Map<String, Object> getTrainsQueryListParam(Long pid, Long trainTo, Long trainFrom, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)pid)) {
            params.put("pid", pid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)trainFrom)) {
            params.put("train_at & >=", trainFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)trainTo)) {
            params.put("train_at & <=", trainTo);
        }
        if (isCount) {
            params.put("@query", "count(id)");
        } else {
            params.put("@order", "train_at desc");
            params.put("@query", "id");
        }
        params.put("@table", "train");
        return params;
    }

    public static Map<String, Object> getDoctorQueryListParam(String mobile, String name, Long registerFrom, Long registerTo, Integer status, Integer accountStatus, Long ageFrom, Long ageTo, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("user user");
        tables.add("doctor doctor");
        params.put("user.id", "doctor.id");
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("user.mobile & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("user.name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerFrom)) {
            params.put("user.create_at & >=", registerFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerTo)) {
            params.put("user.create_at & <=", registerTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)ageFrom)) {
            params.put("user.birth & >=", ageFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)ageTo)) {
            params.put("user.birth & <=", ageTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)accountStatus)) {
            params.put("user.status", accountStatus);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("doctor.status", status);
        }
        if (isCount) {
            params.put("@query", "count(user.id)");
        } else {
            params.put("@order", "user.create_at desc");
            params.put("@query", "user.id");
        }
        params.put("user.type", 0);
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getDoctorManagerQueryListParam(Long hid, String mobile, String name, Long registerFrom, Long registerTo, Integer status, Integer accountStatus, String position, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("user user");
        tables.add("doctor doctor");
        params.put("user.id", "doctor.id");
        if (DataUtils.isNotNullOrEmpty((Object)accountStatus)) {
            params.put("user.status", accountStatus);
        }
        if (DataUtils.isNotNullOrEmpty((Object)hid)) {
            params.put("doctor.hid", hid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("user.mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)position)) {
            params.put("doctor.position & like", "'" + position + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("user.name & like", "'%" + name + "%'");
        }
        params.put("doctor.status ", 2);
        if (DataUtils.isNotNullOrEmpty((Object)registerFrom)) {
            params.put("user.create_at & >=", registerFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerTo)) {
            params.put("user.create_at & <=", registerTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("doctor.status", status);
        }
        if (isCount) {
            params.put("@query", "count(doctor.id)");
        } else {
            params.put("@order", "doctor.apply desc ");
            params.put("@query", "doctor.id");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        log.info((Object)("=======" + params));
        return params;
    }

    public static Map<String, Object> getTemplateQueryListParam(Long did, String name, Long createFrom, Long createTo, Long countTo, Long countFrom, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)did)) {
            params.put("did", did);
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createFrom)) {
            params.put("template_at & >=", createFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createTo)) {
            params.put("template_at & <=", createTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)countFrom)) {
            params.put("count & >=", countFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)countTo)) {
            params.put("count & <=", countTo);
        }
        if (isCount) {
            params.put("@query", "count(id)");
        } else {
            params.put("@order", "template_at desc");
            params.put("@query", "id");
        }
        params.put("@table", "template");
        return params;
    }

    public static Map<String, Object> getProgramQueryListParam(Long did, String name, String mobile, Long createFrom, Long createTo, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("program_relation program_relation");
        tables.add("user user");
        params.put("program_relation.pid", "user.id");
        if (DataUtils.isNotNullOrEmpty((Object)did)) {
            params.put("program_relation.did", did);
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("program_relation.name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("user.mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createFrom)) {
            params.put("program_relation.create_at & >=", createFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createTo)) {
            params.put("program_relation.create_at & <=", createTo);
        }
        if (isCount) {
            params.put("@query", "count(program_relation.id)");
        } else {
            params.put("@order", "program_relation.create_at desc");
            params.put("@query", "program_relation.id");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getHospitalQueryParam(Integer grade, String name, Integer totalFrom, Integer totalTo, Integer status, String province, String city, boolean isConut) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)grade)) {
            params.put("grade", grade);
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)totalFrom)) {
            params.put("total & >=", totalFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)totalTo)) {
            params.put("total & <=", totalTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)province)) {
            params.put("province & like", "'%" + province + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)city)) {
            params.put("city & like", "'%" + city + "%'");
        }
        if (isConut) {
            params.put("@query", "count(id)");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id");
        }
        params.put("@table", "hospital");
        return params;
    }

    public static Map<String, Object> getContentsQueryListParam(Integer[] type, Integer status, String title, Long createBy, Long createStartAt, Long createEndAt, Long publishStartAt, Long publishEndAt, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t == null) continue;
                    sb.append(t.toString());
                    sb.append(",");
                    ++i;
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }
        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");
        return params;
    }

    public static Map<String, Object> getCommentQueryParams(Long did, String mobile, String name, Long createFrom, Long createTo, Integer star, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> table = new HashSet<String>();
        table.add("comment comment");
        table.add("user user");
        params.put("comment.pid", "user.id");
        if (DataUtils.isNotNullOrEmpty((Object)did)) {
            params.put("comment.did", did);
        }
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("user.mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("user.name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createFrom)) {
            params.put("comment.comment_at & >=", createFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createTo)) {
            params.put("comment.comment_at & <=", createTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)star)) {
            params.put("comment.star", star);
        }
        if (isCount) {
            params.put("@query", "count(comment.id)");
        } else {
            params.put("@order", "comment.comment_at desc");
            params.put("@query", "comment.id");
        }
        String tables = SQLUtil.convertTable(table);
        params.put("@table", tables);
        return params;
    }

    public static Map<String, Object> getCertificationQueryListParam(String mobile, String name, Long registerFrom, Long registerTo, Integer status, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("user user");
        tables.add("doctor doctor");
        params.put("user.id", "doctor.id");
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("user.mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("user.name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerFrom)) {
            params.put("doctor.apply & >=", registerFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerTo)) {
            params.put("doctor.apply & <=", registerTo);
        }
        if (DataUtils.isNullOrEmpty((Object)status)) {
            params.put("doctor.status & in ", "(1,2,3,4)");
        } else {
            params.put("doctor.status", status);
        }
        if (isCount) {
            params.put("@query", "count(doctor.id)");
        } else {
            params.put("@order", "doctor.apply desc");
            params.put("@query", "doctor.id");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getOrderQueryListParam(Long did, Long pid, Integer type, Integer status, String product, Long payStartAt, Long payEndAt, String amountStart, String amountEnd, Integer way, Boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        log.info((Object)"start select from orders");
        if (DataUtils.isNotNullOrEmpty((Object)way)) {
            params.put("way", way);
        }
        if (DataUtils.isNotNullOrEmpty((Object)did)) {
            params.put("did", did);
        }
        if (DataUtils.isNotNullOrEmpty((Object)pid)) {
            params.put("pid", pid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)product)) {
            params.put("product & like", "'%" + product + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)payStartAt)) {
            params.put("pay_at & >=", payStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)payEndAt)) {
            params.put("pay_at & <=", payEndAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)amountStart)) {
            params.put("amount & >=", amountStart);
        }
        if (DataUtils.isNotNullOrEmpty((Object)amountEnd)) {
            params.put("amount & <=", amountEnd);
        }
        if (isCount.booleanValue()) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "orders");
        return params;
    }

    public static Map<String, Object> getVersionListParam(String os, Integer type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)os)) {
            params.put("img", " '" + os + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put("type", type);
        }
        params.put("@order", "  title desc ");
        params.put("@query", " id");
        params.put("@table", " article ");
        log.info((Object)("getVersionList sql is: " + SQLUtil.convert2Sql(params, (Integer)0, (Integer)0)));
        return params;
    }

    public static Map<String, Object> getVersionList(boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", " version ");
        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@order", "update_at desc");
            params.put("@query", "id");
        }
        log.info((Object)("getVersionList sql is: " + SQLUtil.convert2Sql(params, (Integer)0, (Integer)0)));
        return params;
    }

    public static Map<String, Object> getMessageList(String title, Integer status, String createBy, Long startAt, Long endAt, Integer personType, boolean count) {
        HashedMap params = new HashedMap();
        HashSet<String> tables = new HashSet<String>();
        tables.add("message");
        if (DataUtils.isNotNullOrEmpty((Object)title)) {
            params.put("message.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("message.status ", " '" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)personType)) {
            params.put("message.person_type ", " '" + personType + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            params.put("message.update_at & <= ", " '" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            params.put("message.update_at & >= ", " '" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createBy)) {
            tables.add("muscle_admin.manager");
            params.put("message.create_by", "manager.id ");
            params.put("manager.name & like ", "'%" + createBy + "%'");
        }
        if (count) {
            params.put("@query", " count(message.id) ");
        } else {
            params.put("@order", "  message.update_at desc  ");
            params.put("@query", " message.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getPatientQueryListParam(String mobile, String name, Long registerFrom, Long registerTo, Integer accountStatus, Long ageFrom, Long ageTo, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            params.put("mobile & like", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put("name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerFrom)) {
            params.put("create_at & >=", registerFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)registerTo)) {
            params.put("create_at & <=", registerTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)ageFrom)) {
            params.put("birth & >=", ageFrom);
        }
        if (DataUtils.isNotNullOrEmpty((Object)ageTo)) {
            params.put("birth & <=", ageTo);
        }
        if (DataUtils.isNotNullOrEmpty((Object)accountStatus)) {
            params.put("status", accountStatus);
        }
        if (isCount) {
            params.put("@query", "count(id)");
        } else {
            params.put("@order", "create_at desc");
            params.put("@query", "id");
        }
        params.put("type", 1);
        params.put("@table", "user");
        return params;
    }

    public static Map<String, Object> getCityQueryParams(String name) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            param.put("name & like", "'" + name + "'");
        }
        param.put("@query", "id");
        param.put("@order", "create_at desc");
        param.put("@table", "city");
        return param;
    }

    public static Map<String, Object> getConstantListParam(String type, String name, String value, String comments, Long startAt, Long endAt, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        log.info((Object)"start select from constant");
        tables.add("constant");
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            params.put("create_at &  <= ", endAt);
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " create_at desc ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getUser(Integer type, Integer status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put("user.type", type);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            if (status == 2) {
                params.put("user.status", status);
            } else {
                String string = "0,1,3,4";
                params.put("user.status & in ", "(" + string + ")");
            }
        }
        params.put("@query", " user.id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getUserMessage(Integer uid, Integer status, Long messageId, Integer type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)messageId)) {
            params.put("message_id", messageId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put("type", type);
        }
        params.put("@query", "id");
        params.put("@table", "userMessage");
        return params;
    }

    public static Map<String, Object> getPlQuery(String os, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(" os & like ", "'" + os + "'");
        params.put(" type & like ", "'" + type + "'");
        params.put("@query", "id");
        params.put("@table", "version");
        return params;
    }

    public static Map<String, Object> uidGetequipmentRelation(Long uid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("uid", uid);
        }
        params.put("@order by", "create_at desc");
        params.put("@query", "id");
        params.put("@table", "equipment_relation");
        return params;
    }
}

