package com.ptteng.muscle.util;

import com.gemantic.common.util.StringUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2016/12/6.
 */
public class FeedBackUtil {

    public static Map<String,Object> getFeedBackList(String mobile,String name,
                                                     Integer type,Long startAt,Long endAt,boolean count){
        Map<String,Object> params=new HashedMap();
        Long now = System.currentTimeMillis();

        Set<String> tables = new HashSet();
        tables.add("feedback");


        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" feedback.create_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" feedback.create_at & <= ", "'" + endAt + "'");
        }

        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put("feedback.type", type);
        }

        if(DataUtils.isNotNullOrEmpty(mobile)){
            params.put(" feedback.mobile & like ","'%"+mobile+"%'");

        }

        if(StringUtil.isNotEmpty(name))
        {
            if(StringUtil.isNotEmpty(name)){
                params.put(" user.name & like ","'%"+name+"%'");

            }

            params.put("feedback.uid", "user.id");
            tables.add("muscle.user");
        }

        if (count) {
            params.put("@query", " count(feedback.id) ");
        }else {
            params.put("@order", "  feedback.update_at desc ");
            params.put("@query", " feedback.id");

        }
        String table = convertTable(tables);
        params.put("@table", table);

        return params;
    }
    public static String convertTable(Set<String> tables) {
        StringBuffer tableBuffer = new StringBuffer();
        int index = 0;
        Iterator var4 = tables.iterator();

        while(var4.hasNext()) {
            String table = (String)var4.next();
            ++index;
            tableBuffer = tableBuffer.append(table);
            if(index < tables.size()) {
                tableBuffer = tableBuffer.append(",");
            }
        }

        return tableBuffer.toString();
    }
}
