package com.ptteng.muscle.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.muscle.model.Article;
import com.ptteng.muscle.main.model.User;
import com.qding.common.util.DataUtils;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DynamicUtil {
	private static final Log log = LogFactory.getLog(DynamicUtil.class);


	public static Map<String, Object> getBloodFlowRQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at desc");
		params.put("@query", "id");
		params.put("@table", "bloodFlow_report");
		return params;
	}

	public static Map<String, Object> getTemperatureChecksQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at");
		params.put("@query", "id");
		params.put("@table", "temperature_check");
		return params;
	}

	public static Map<String, Object> getTemperatureChecksStemQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at");
		params.put("@query", "id");
		params.put("@table", "temperature_check_stem");
		return params;
	}

	public static Map<String, Object> getSensitityQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at desc");
		params.put("@query", "id");
		params.put("@table", "sensitivity_report");
		return params;
	}

	public static Map<String, Object> getHardessReportRootTQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at desc");
		params.put("@query", "id");
		params.put("@table", "hardness_report_root");
		return params;
	}

	public static Map<String, Object> getHardessReportQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at desc");
		params.put("@query", "id");
		params.put("@table", "hardness_report");
		return params;
	}

	public static Map<String, Object> getHardnessDetectionQuery(String time, String mobile) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(time)) {
			params.put("detection_at & like", "'" +time +"'");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at desc");
		params.put("@query", "id");
		params.put("@table", "hardness_detection");
		return params;
	}


	public static Map<String, Object> getHardessQuery(StringBuffer hardessT, String mobile) {
		Map<String, Object> params = new HashMap<>();
		String s = hardessT.toString();
		if (DataUtils.isNotNullOrEmpty(s)) {
			params.put("detection_at & in ","(" + s + ")");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "rau ");
		params.put("@query", "id");
		params.put("@table", "hardness_report");

		return params;
	}

	public static Map<String, Object> getHardessTauQuery(StringBuffer hardessT, String mobile) {
		Map<String, Object> params = new HashMap<>();
		String s = hardessT.toString();
		if (DataUtils.isNotNullOrEmpty(s)) {
			params.put("detection_at & in ","(" + s + ")");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "tau ");
		params.put("@query", "id");
		params.put("@table", "hardness_report");

		return params;
	}


	public static Map<String, Object> getHardessReportRootQuery(StringBuffer hardessT, String mobile) {
		Map<String, Object> params = new HashMap<>();
		String s = hardessT.toString();
		if (DataUtils.isNotNullOrEmpty(s)) {
			params.put("detection_at & in ","(" + s + ")");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "rau_root ");
		params.put("@query", "id");
		params.put("@table", "hardness_report_root");

		return params;
	}

	public static Map<String, Object> getHardessReportRootTauQuery(StringBuffer hardessT, String mobile) {
		Map<String, Object> params = new HashMap<>();
		String s = hardessT.toString();
		if (DataUtils.isNotNullOrEmpty(s)) {
			params.put("detection_at & in ","(" + s + ")");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "tau_root ");
		params.put("@query", "id");
		params.put("@table", "hardness_report_root");

		return params;
	}

	public static Map<String,Object> getBloodFlowQuery(StringBuffer bloodFlowT,String mobile){
		Map<String, Object> params = new HashMap<>();
		String s = bloodFlowT.toString();
		if (DataUtils.isNotNullOrEmpty(s)) {
			params.put("detection_at & in ","(" + s + ")");
		}

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile & like", "'" +mobile +"'");
		}

		params.put("@order", "create_at desc");
		params.put("@query", "id");
		params.put("@table", "bloodFlow_report");

		return params;

	}

	public static Map<String, Object> getSensitityReportQuery(Long createFrom, Long createTo,String mobile,boolean isCount) {
		Map<String, Object> param = new HashMap<>();

		if (DataUtils.isNotNullOrEmpty(mobile)) {
			param.put("mobile & like", "'%" +mobile +"%'");
		}

		if (DataUtils.isNotNullOrEmpty(createFrom)) {
			param.put("ins_at & >=", createFrom);
		}

		if (DataUtils.isNotNullOrEmpty(createTo)) {
			param.put("ins_at & <=", createTo);
		}

		if (isCount) {
			param.put("@query", "count(id)");
		} else {
			param.put("@order", "ins_at desc");
			param.put("@query", "id");
		}

		param.put("@table", "sensitivity_report");
		return param;
	}

	public static Map<String,Object> getPlQuery(String os,String type){
		Map<String, Object> params = new HashMap<>();


		params.put(" os & like ", "'" + os + "'");
		params.put(" type & like ", "'" + type + "'");
		params.put("@query", "id");
		params.put("@table", "version");
		return params;
	}


	public static Map<String, Object> getEquipmentlRelationQueryParam(Long uid, Long eid) {

		Map<String, Object> params = new HashMap<>();
		Set<String> table = new HashSet<>();
		table.add("equipment_relation");

		if (DataUtils.isNotNullOrEmpty(uid)) {
			params.put("equipment_relation.uid & =", "'%" + uid + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(eid)) {
			params.put("equipment_relation.eid & =", "'%" + eid + "%'");
		}

		params.put("@order by", "equipment_relation.create_at desc");
		params.put("@query", "equipment_relation.id");

		String tables = SQLUtil.convertTable(table);
		params.put("@table", tables);
		return params;
	}

	public static Map<String, Object> getCommentQueryParam(Long did, Long pid, boolean isCount) {
		Map<String, Object> params = new HashMap<>();

		if (DataUtils.isNotNullOrEmpty(did)) {
			params.put("did", did);
		}

		if (DataUtils.isNotNullOrEmpty(pid)) {
			params.put("pid", pid);
		}

		if (isCount) {
			params.put("@query", "count(id)");
		} else {
			params.put("@order", "comment_at desc");
			params.put("@query", "id");
		}

		params.put("@table", "comment");

		return params;
	}

	public static Map<String, Object> getEquipmentlQueryParam(String model, String version, String os,
			String device_token) {
		Map<String, Object> params = new HashMap<>();
		Set<String> table = new HashSet<>();
		table.add("equipment");

		if (DataUtils.isNotNullOrEmpty(model)) {
			params.put("equipment.model & like", "'%" + model + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(version)) {
			params.put("equipment.version & like", "'%" + version + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(os)) {
			params.put("equipment.os & like", "'%" + os + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(os)) {
			params.put("equipment.os & like", "'%" + os + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(device_token)) {
			params.put("equipment.device_token & like", "'%" + device_token + "%'");
		}

		params.put("@order by", "equipment.create_at desc");
		params.put("@query", "equipment.id");

		String tables = SQLUtil.convertTable(table);
		params.put("@table", tables);
		return params;
	}

	public static Map<String, Object> getMessageList(String title, Integer status, String createBy, Long startAt,
			Long endAt, boolean count) {
		Map<String, Object> params = new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("message");
		if (DataUtils.isNotNullOrEmpty(title)) {
			params.put("message.title & like", " '%" + title + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("message.status ", " '" + status + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("message.push_at & <= ", " '" + endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("message.push_at & >= ", " '" + startAt + "'");
		}
		params.put("message.push_at & <= ", "'" + System.currentTimeMillis() + "'");

		if (DataUtils.isNotNullOrEmpty(createBy)) {
			tables.add("jinxin_public.manager");
			params.put("message.create_by", "manager.id ");
			params.put("manager.name & like ", "'%" + createBy + "%'");
		}

		if (count) {
			params.put("@query", " count(message.id) ");

		} else {
			params.put("@order", "  message.push_at desc  ");
			params.put("@query", " message.id ");
		}

		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;

	}

	public static Map<String, Object> getOrderQueryListParam(Long did, Integer status, Boolean isCount) {
		Map<String, Object> params = new HashMap<String, Object>();
		log.info("start select from orders");

		if (DataUtils.isNotNullOrEmpty(did)) {
			params.put("did", did);
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}

		if (isCount) {
			params.put("@query", "count(id) ");
		} else {
			params.put("@order", "create_at desc ");
			params.put("@query", "id ");
		}
		params.put("@table", "orders");
		return params;
	}

	public static Map<String, Object> getApplyListParam(Long did, String name, Integer status, boolean isCount) {

		LinkedHashMap<String , Object> params = new LinkedHashMap<String, Object>();
		Set<String> table = new HashSet<>();
		table.add("apply");
		table.add("user");
		
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("(user.name & like", "'%" + name + "%' or user.mobile like" + "'%" + name + "%')");
		}

		if (DataUtils.isNotNullOrEmpty(did)) {
			params.put("apply.did", did);
		}

		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("apply.status", status);
		}
		
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("user.id", "apply.pid");
		}
		
		if (isCount) {
			params.put("@query", "count(apply.id)");
		} else {
			params.put("@order by", "create_at desc");
			params.put("@query", "apply.id");
		}

		String tables = SQLUtil.convertTable(table);
		params.put("@table", tables);

		String convert2Sql = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
		System.out.println("==================语句：" + convert2Sql);

		return params;
	}

	public static Map<String, Object> getNewsletterListParam(Long did, String name, boolean isCount) {

		LinkedHashMap<String , Object> params = new LinkedHashMap<String, Object>();
		Set<String> table = new HashSet<>();
		table.add("patient");
		table.add("user");
		
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("(user.name & like", "'%" + name + "%' or user.mobile like" + "'%" + name + "%')");
		}
		
		if (DataUtils.isNotNullOrEmpty(did)) {
			params.put("patient.did", did);
		}
		
		if (DataUtils.isNotNullOrEmpty(did)) {
			params.put("user.id", "patient.id");
		}

		if (isCount) {
			params.put("@query", "count(patient.id)");
		} else {
			params.put("@order by", "create_at desc");
			params.put("@query", "patient.id");
		}

		String tables = SQLUtil.convertTable(table);
		params.put("@table", tables);

		/*
		 * String convert2Sql = SQLUtil.convert2Sql(params, 0,
		 * Integer.MAX_VALUE);
		 * System.out.println("==================语句："+convert2Sql);
		 */

		return params;
	}

	public static Map<String, Object> getTemplateQueryListParam(Long did, String name, Long createFrom, Long createTo,
			Long countTo, Long countFrom, boolean isCount) {

		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(did)) {
			params.put("did", did);
		}

		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", "'%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(createFrom)) {
			params.put("create_at & >=", createFrom);
		}

		if (DataUtils.isNotNullOrEmpty(createTo)) {
			params.put("create_at & <=", createTo);
		}

		if (DataUtils.isNotNullOrEmpty(countFrom)) {
			params.put("count & >=", countFrom);
		}

		if (DataUtils.isNotNullOrEmpty(countTo)) {
			params.put("count & <=", countTo);
		}

		if (isCount) {
			params.put("@query", "count(id)");
		} else {
			params.put("@order by", "create_at desc");
			params.put("@query", "id");
		}

		params.put("@table", "template");

		return params;
	}

	public static Map<String, Object> getArticleListParam(Long startAt, Long endAt, Integer type, String createBy,
			String title, String status, String author) {

		Map<String, Object> params = new HashMap<String, Object>();
		Set<String> tables = new HashSet();
		tables.add("article");

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" article.update_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(title)) {
			params.put("article.title & like", " '%" + title + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" article.update_at & <= ", "'" + endAt + "'");
		}

		if (DataUtils.isNotNullOrEmpty(author)) {
			params.put("article.author & like", " '%" + author + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(type)) {

			params.put("article.type", type);
		}

		if (DataUtils.isNotNullOrEmpty(createBy)) {
			params.put("article.create_by", "manager.id");
			params.put("manager.name & like ", "'%" + createBy + "%'");
			tables.add("manager");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("article.status", status);

		}

		if (DataUtils.isNullOrEmpty(type)) {
			params.put("article.type & !=", Article.ARTICLE_TYPE_4);
		}

		params.put("@order", "  article.orderBy asc ");
		params.put("@query", " article.id");

		String table = FeedBackUtil.convertTable(tables);
		params.put("@table", table);

		return params;
	}

	public static Map<String, Object> getProgramRelationQueryListParam(Long pid, boolean isCount) {
		Map<String, Object> params = new HashMap<>();

		if (DataUtils.isNotNullOrEmpty(pid)) {
			params.put("pid", pid);

		}

		params.put(" status & in ", "(" + 0 + "," + 1 + ")");

		if (isCount) {
			params.put("@query", "count(id) ");
		} else {
			params.put("@order", "buy_at desc ");
			params.put("@query", "id ");
		}

		params.put("@table", "program_relation");
		return params;
	}

	// 查询常量列表
	public static Map<String, Object> getConstantProgramParam() {

		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();
		log.info("start select from constant");

		params.put("type & like", " '%" + "program" + "%'");

		params.put("@table", "constant");
		return params;
	}

	public static Map<String, Object> getVersionParams(String app, String platform, boolean isCount) {
		Map<String, Object> params = new HashMap<>();

		if (DataUtils.isNotNullOrEmpty(app)) {
			params.put("app & like", " '%" + app + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(platform)) {
			params.put("platform & like", " '%" + platform + "%'");
		}

		params.put("@table", " version ");
		if (isCount) {
			params.put("@query", "count(id)");

		} else {
			params.put("@order", "update_at desc");
			params.put("@query", "id");
		}

		log.info("getVersionList sql is: " + SQLUtil.convert2Sql(params, 0, 0));

		return params;
	}

	// 查询常量列表
	public static Map<String, Object> getConstantListParam(String type, String name, String value, String comments,
			Long startAt, Long endAt, boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();
		log.info("start select from constant");
		tables.add("constant");

		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put(" type & like ", "'%" + type + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put(" name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(value)) {
			params.put(" value & like ", "'%" + value + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(comments)) {
			params.put(" comments & like ", "'%" + comments + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("leaves.create_at & >= ", startAt);
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("leaves.create_at &  <= ", endAt);
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", " create_at desc ");
			params.put("@query", " id ");
		}
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}

	public static Map<String, Object> getHospitalQueryParam(Integer grade, String name, Integer totalFrom,
			Integer totalTo, Integer status, String province, String city, Long cid, boolean isConut) {

		Map<String, Object> params = new HashMap<>();

		if (DataUtils.isNotNullOrEmpty(grade)) {
			params.put("grade", grade);
		}

		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", "'%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(totalFrom)) {
			params.put("total & >=", totalFrom);
		}

		if (DataUtils.isNotNullOrEmpty(totalTo)) {
			params.put("total & <=", totalTo);
		}

		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}

		if (DataUtils.isNotNullOrEmpty(province)) {
			params.put("province & like", "'%" + province + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(city)) {
			params.put("city & like", "'%" + city + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(cid)) {
			params.put("cid", cid);
		}

		if (isConut) {
			params.put("@query", "count(id)");
		} else {
			params.put("@order by", "create_at desc");
			params.put("@query", "id");
		}

		params.put("@table", "hospital");

		return params;
	}

}
