package com.ptteng.muscle.main.controller;


import com.gemantic.common.util.StringUtil;
import com.ptteng.muscle.common.model.Version;
import com.ptteng.muscle.common.service.VersionService;
import com.ptteng.muscle.util.DynamicUtil;
import com.ptteng.muscle.util.VersionIsForceUpdateCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Controller
public class VersionController {
    private static final Log log = LogFactory.getLog(VersionService.class);

    @Autowired
    private VersionService versionService;

    private static final String OS = "os";

    private static final String VERSION = "version";

    private static final String TYPE = "type";


    @RequestMapping(value = "/test", method = RequestMethod.GET)
    public String getMultiProgressJson(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("this is the demo web");

        return "/demo/link";
    }


    //我的信息
    @RequestMapping(value = "/a/version", method = RequestMethod.GET)
    public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info("version update control begin ==================");
        String os = request.getParameter(OS);
        String version = request.getParameter(VERSION);
        String type = request.getParameter(TYPE);
        if (StringUtil.isEmpty(version)) {
            version = request.getHeader(VERSION);
        }
        if (StringUtil.isEmpty(os)) {
            os = request.getHeader(OS);
        }
        if (StringUtil.isEmpty(type)) {
            os = request.getHeader(TYPE);
        }
        log.info("os = " + os + "     version = " + version + "        type = " + type);
        try {

            Integer needUpdate = 1;//只要不是最新版本，都需要更新，其中会有是否需要强制更新的差别

            //参数校验
            if (StringUtil.isEmpty(os)) {
                log.info("arg os is empty and need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate",needUpdate);
                return "/muscle-main-service/system/version";
            }
            if (StringUtil.isEmpty(version)) {
                log.info("arg version is empty need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate",needUpdate);
                return "/muscle-main-service/system/version";
            }
            if (StringUtil.isEmpty(type)) {
                log.info("arg version is empty need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate",needUpdate);
                return "/muscle-main-service/system/version";
            }

            //获取最新版本
            Map<String,Object> params = DynamicUtil.getPlQuery(os,type);
            log.info("patient android version params is :" + params);
            List<Long> paramsList = versionService.getIdsByDynamicCondition(Version.class, params, 0, Integer.MAX_VALUE);
            log.info("patient android version params get dynamic ids is :" +paramsList);

            List<Version> versionListByOs = versionService.getObjectsByIds(paramsList);
            Collections.sort(versionListByOs);

            List<Version> versionList = new ArrayList<>();
            model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.noNeedForceUpdate.getValue());
            for (Version systemVersion : versionListByOs) {
                switch (systemVersion.compareCode(systemVersion.getVersionCode(), version)) {
                    case 1:
                        versionList.add(systemVersion);
                        if (systemVersion.getIsForceUpdate()) {
                            log.info("need force updating");
                            model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                        } else {
                            log.info("version : " + systemVersion.getVersionCode() + " is a new version but not need tu force updating");
                        }
                        break;
                    default:
                        break;
                }
            }

            Version latestVersion = null;
            log.info("new version list is" + versionList);
            if (CollectionUtils.isEmpty(versionList)) {
                log.info("version is new and don't need force updating");
                needUpdate = 0;//versionList 为空说明当前版本为最新版本，不需要更新
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.latestUpdateVersion.getValue());
            } else {
                log.info("version is not new but don't need force updating");
                latestVersion = versionList.get(0);
            }
            log.info("latest version is" + latestVersion);
            log.info("get latestVersionInfo finish ==========");

            model.addAttribute("code", 0);
            model.addAttribute("needUpdate",needUpdate);
            model.addAttribute("version", latestVersion);

        } catch (Throwable t) {
            log.error("VersionManager error...", t);
            model.put("code", -1);
        }
        log.info("version update control end ==================");
        return "/muscle-main-service/system/version";
    }
}
