package com.ptteng.muscle.main.controller;

import com.ptteng.common.muscle.model.Article;
import com.ptteng.muscle.common.model.Message;
import com.ptteng.muscle.common.model.UserMessage;
import com.ptteng.muscle.common.service.MessageService;
import com.ptteng.muscle.common.service.UserMessageService;
import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * UserMessage  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class UserMessageController {
	private static final Log log = LogFactory.getLog(UserMessageController.class);

	@Autowired
	private UserMessageService userMessageService;
	@Autowired
	private MessageService messageService;


	/**
	 * 查询用户是否有未读消息:只查询最近的10条，超过的不查
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */
		@RequestMapping(value = "/a/u/message/status", method = RequestMethod.GET)
	public String getMessageStatus(HttpServletRequest request,
												 HttpServletResponse response, ModelMap model) throws Exception {
		log.info(" getMessageStatus  ");
		User user = (User)request.getAttribute("user");
		Long uid = user.getId();
		List<Long> unreadMessageIds = userMessageService.getUserMessageIdsByUidAndStatus(uid, UserMessage.UNREAD, 0, 1);
        log.info("unreadMessageIds========="+unreadMessageIds);

		if(unreadMessageIds.size()>0){
			log.info(" user " + uid + " has  unread messages");
			model.addAttribute("code",0);
			model.addAttribute("status",UserMessage.UNREAD);
			return "/common/json3";
		}else {
			model.addAttribute("code",0);
			model.addAttribute("status",UserMessage.READ);
			return "/common/json3";
		}

	}


		@RequestMapping(value = "/a/u/message/search", method = RequestMethod.GET)
	public String getUserMessageIdsByUidJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size) throws Exception {
			log.info(" page = "+page+" size = "+size);
			User user = (User)request.getAttribute("user");
			Long uid = user.getId();

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : start= " + start + " , size=" + size);

		try {


//			List<Long> messageIds = new ArrayList<>();

			List<Long> ids= userMessageService.getUserMessageIdsByUid(uid, 0,Integer.MAX_VALUE);
		    log.info("get countUserMessageIdsByUid size is " + ids.size()+"ids====="+ids);

			List<UserMessage> userMessageList = userMessageService.getObjectsByIds(ids);
			log.info("get userMessage data is " + userMessageList.size());
			List<Long> unreadIds = userMessageService.getUserMessageIdsByUidAndStatus(uid,UserMessage.UNREAD,0,Integer.MAX_VALUE);

			List<Long> messageIds= new ArrayList<>();
			List<Long> messageIdsList=new ArrayList<>();
			List<Message> messages = new ArrayList<>();
			Long messageId = null;
			for(UserMessage userMessage :userMessageList){
				messageId=userMessage.getMessageId();
				Message message=messageService.getObjectById(messageId);
				if(message.getPushAt()<System.currentTimeMillis()){
					messageIds.add(messageId);
				}
			}
			for (int i = messageIds.size() - 1; i >= 0; i--){
				if(i<page*size&&i>(size*(page-1)-1)){
					messageIdsList.add(messageIds.get(i));
				}
			}

			for (int st = 0, end = messageIdsList.size() - 1; st < end; st++, end--) {
				Long temp = messageIdsList.get(end);
				messageIdsList.set(end, messageIdsList.get(st));
				messageIdsList.set(st, temp);
			}

			log.info("messageIdsList==========="+messageIdsList);
			List<Message> messageList=messageService.getObjectsByIds(messageIdsList);

			for(Message messageListOne:messageList){
				for(UserMessage userMessageOne:userMessageList){
					log.info("messageListOne.getId()========"+messageListOne.getId());
					log.info("userMessageOne.getMessageId()========"+userMessageOne.getMessageId());
					log.info("----------------------------");
					if(messageListOne.getId().equals(userMessageOne.getMessageId())){
						messageListOne.setRead(userMessageOne.getStatus());
						log.info("userMessageOne.getStatus()==========="+userMessageOne.getStatus());

					}
				}
			}

			log.info("messageList==========="+messageList);

			Integer total = messageIds.size();
			int totalPage = 1;
			if(null != total){
				if(total>0){
					totalPage = (((total- 1)) / (size)) + 1;;
				}
			}
			log.info("get userMessage count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("total", total);
			model.addAttribute("messageList", messageList);

			if(unreadIds.size()>0){
				List<UserMessage> userMessages = userMessageService.getObjectsByIds(unreadIds);
				for(UserMessage userMessage : userMessages){
					userMessage.setStatus(UserMessage.READ);
				}
				userMessageService.updateList(userMessages);
			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userMessage list error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -1);
		}

		return "/muscle-main-service/userMessage/json/userMessageListJson";
	}


}

