package com.ptteng.muscle.main.controller;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.muscle.main.model.*;
import com.ptteng.muscle.common.model.Sms;
import com.ptteng.muscle.main.service.*;
import com.qding.common.util.http.cookie.IdentityUtil;

import net.sf.json.JSONObject;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.service.EquipmentService;
import com.ptteng.muscle.common.service.SmsService;
import com.ptteng.muscle.constant.InterfaceCodeConstant;
import com.ptteng.muscle.interceptor.CookieConstant;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * User crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);


	@Autowired
	private ConstantService constantService;
	@Autowired
	private UserService userService;
	@Autowired
	private SmsService smsService;

	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private DoctorService doctorService;
	@Autowired
	private EquipmentService equipmentService;

	@Autowired
	private EquipmentRelationService equipmentRelationService;

	@Resource(name = "accountConfig")
	private Map<String, String> accountConfig;
	@Autowired
	private NoticeUtil androidPushServiceImpl;
	@Autowired
	private NoticeUtil iosPushServiceImpl;

	/* 医师登录 */
	@RequestMapping(value = "/a/doctor/login", method = RequestMethod.POST)
	public String login(HttpServletRequest request, HttpServletResponse response, ModelMap mapModel, String mobile,
			String pwd, String model, String os, String version, String deviceToken) throws Exception {

		log.info("Doctor login is "+"mobile " + mobile + "password " + pwd);

		if (mobile == null) {
			mapModel.addAttribute("code", -1000);
			return "/common/success";
		}
		
		Long uid = userService.getUserIdByMobileAndType(mobile,0);
		String token = IdentityUtil.encodeCookie("phone", uid);

		if (uid == null) {
			mapModel.addAttribute("code", -2000);
			return "common/success";
		}
		log.info("uid is " + uid);
		User user = this.userService.getObjectById(uid);
		
		
		if (!user.getType().equals(User.DOCTOR_TYPE)){
			mapModel.addAttribute("code", -2000);
			return "common/success";
		}
		
		
		
		String pass = PasswordUtils.encode(pwd);
		Boolean verify = user.getPwd().equals(pass);

		if (verify) {
			log.info(uid + " login ");
			Map<String, String> maps = new HashMap();

			maps.put(CookieUtil.USER_ID, uid + "");
			maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
			cookieUtil.setIdentity(request, response, maps, uid);

			/* 判断是否添加过该设备 */
			Long equmpentIdd = equipmentService.getEquipmentByDeviceToken(deviceToken);
			if (DataUtils.isNullOrEmpty(equmpentIdd)) {
				Equipment equipment = new Equipment();
				equipment.setModel(model);
				equipment.setVersion(version);
				equipment.setOs(os);
				equipment.setDeviceToken(deviceToken);
				equipmentService.insert(equipment);

				Long eid = equipmentService.getEquipmentByDeviceToken(deviceToken);
				/* 创建存储对象 */
				EquipmentRelation equipmentRelation = new EquipmentRelation();
				equipmentRelation.setUid(uid);
				equipmentRelation.setEid(eid);

				equipmentRelationService.update(equipmentRelation);
				mapModel.addAttribute("code", "0");
				mapModel.addAttribute("message", "success");
				log.info("add equipmentRelation success .  uid = " + uid + " eid = " + eid);
			}

			mapModel.addAttribute("code", 0);
			mapModel.addAttribute("uid", uid);
			mapModel.addAttribute("token", token);
			mapModel.addAttribute("deviceToken", deviceToken);
			mapModel.addAttribute("model", model);
			mapModel.addAttribute("mobile", mobile);
		} else {
			log.info(mobile + " wrong pwd " + pwd);
			mapModel.put("code", -2004);
			return "/common/success";
		}

		return "/muscle-main-service/user/json/login";
	}

	/* 医师注册 */
	@RequestMapping(value = "/a/doctor/register", method = RequestMethod.POST)
	public String register(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String mobile,
			String pwd, String verify, String idcard, String model, String os, String version, String deviceToken)
					throws Exception {

		log.info("mobile is " + mobile + "pwd is " + pwd + "verify is " + verify + "idcard is " + idcard + " deviceToken:" + deviceToken);

		String type = "register";

        if (StringUtils.isBlank(mobile) || StringUtils.isBlank(verify) || StringUtils.isBlank(pwd)) {
            modelMap.addAttribute("code", -1000);
            log.info("params is null");
            return "/common/success";
        }


        try {
            boolean verifyResult = false;

            if (verifyModel()) {
                log.info("is test model ");
                if ("555555".equals(verify)) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                    verifyResult = verifyMobileCode(modelMap, mobile, type, verify);
                }
            } else {
                log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                verifyResult = verifyMobileCode(modelMap, mobile, type, verify);
            }

            // 校验验证码
//            Long now = System.currentTimeMillis();
//            SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyyMMdd");
//            String date = myFmt2.format(now);
            //校验邀请码
            if (verifyResult) {
//                Long recommendId = null;

                // 是否已注册
                List<Long> uids = userService.getUserIdsByMobile(mobile);
                log.info("get uids by mobile, size:" + uids.size());

                if (DataUtils.isNotNullOrEmpty(uids)) {

                    List<User> users = userService.getObjectsByIds(uids);

                    if ((users.size() == 2) || (users.size() == 1 && users.get(0).getType() == 0)){
                        log.info(mobile + " is already exist, and the account about doctor already exist");
                        modelMap.addAttribute("code", -2007);
                        return "/common/success";
                    }

                    log.info(mobile + " is already exist , but it is about patient, so register is allowed");

                } else {
                    log.info(mobile + " not exist ,so can register ");
                }

                //创建新user
                User user = new User();
                user.setMobile(mobile);
//                mobile.split(mobile);

                String encodePass = PasswordUtils.encode(pwd);
                user.setPwd(encodePass);
                user.setType(0);
                user.setStatus(0);
                user.setOs(os);
                user.setDeviceToken(deviceToken);

                if (StringUtils.isNotBlank(idcard)) {
                    user.setIdNo(idcard);
                    log.info("idNo is :" + idcard);
                }
                Long uid = userService.insert(user);

                // 判断是否添加过该设备
                Long eid = equipmentService.getEquipmentByDeviceToken(deviceToken);
                if (DataUtils.isNotNullOrEmpty(eid)) {
                    log.info("the equipment already exists");
                }else{
                    Equipment equipment = new Equipment();
                    equipment.setModel(model);
                    equipment.setVersion(version);
                    equipment.setOs(os);
                    equipment.setDeviceToken(deviceToken);
                    eid = equipmentService.insert(equipment);
                }

                // 创建存储对象
                EquipmentRelation equipmentRelation = new EquipmentRelation();
                equipmentRelation.setUid(uid);
                equipmentRelation.setEid(eid);

                Long erId = equipmentRelationService.insert(equipmentRelation);
                log.info("add equipmentRelation success. erId = "+erId + ", uid = " + uid + ", eid = " + eid);

                // 先查询是否添加过该条数据 uid和eid是否有匹配数据
//                Long erId = equipmentRelationService.getEquipmentRelationByUidAndEid(uid, eid);
//                if (DataUtils.isNotNullOrEmpty(erId)) {
//
//                    log.info("the equipmentRelation is already exit, erId = " + erId + ", uid = " + uid + ", eid = " + eid);
////                    modelMap.addAttribute("code", -5072);
////                    return "/common/success";
//                }else {
//
//                }

                /*医师表中插入数据*/
                Doctor doctor = new Doctor();
                doctor.setId(uid);
                Long did = doctorService.insert(doctor);
                log.info("doctor id is "+ did);
                String token = IdentityUtil.encodeCookie("phone", uid);

                log.info(mobile + " register success,uid is " + uid);

                Map<String, String> maps = new HashMap();
                maps.put(CookieUtil.USER_ID, uid + "");
                maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
                cookieUtil.setIdentity(request, response, maps, uid);

                modelMap.addAttribute("token", token);
                modelMap.addAttribute("uid",uid);

                modelMap.addAttribute("code", "0");
                modelMap.addAttribute("message", "success");

            } else {
                log.error("wrong verifycode");
                modelMap.addAttribute("code", -1006);

                return "/common/success";
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            modelMap.addAttribute("code", -1);
        }

		return "/muscle-main-service/user/json/register";
	}

	/* 验证码校验 */
	private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify)
			throws ServiceException, ServiceDaoException {
		log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
		// 是否有发送验证码
		Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
		log.info("sid is " + sid);

		if (sid == null) {
			return false;
		}
		// 获取验证码信息
		Sms sms = smsService.getObjectById(sid);
		log.info("sms is " + sms);
		// 获取验证码
		String message = sms.getMessage();
		log.info("message is " + message);

		// 发送是否超时
		Long delay = System.currentTimeMillis() - sms.getSendAt();

		if (delay > 600000) {
			log.info("require verify too long");
			return false;
		}

		if (message.equals(verify)) {
			return true;
		} else {
			return false;
		}

	}

	private boolean verifyModel() {
		return "test".equals(this.accountConfig.get("testModel"));
	}

	/* 忘记密码  */
	@RequestMapping(value = "/a/doctor/password/forget", method = RequestMethod.PUT)
	public String rewritepwd(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String verify, String newpwd) throws Exception {
		try {
			// 是否已注册
			Long uid = userService.getUserIdByMobileAndType(mobile,0);

			// 用户不存在
			if (uid == null) {
				log.info(mobile + " not exist ");
				model.addAttribute("code", -2000);

				return "/common/success";

			} else {
				log.info(mobile + " exist and uid is " + uid);
			}

			boolean verifyResult = false;

			String type = "password";

			// 测试模式
			if (verifyModel()) {
				if ("555555".equals(verify)) {
					log.info("test ,so not verify mobile ");
					verifyResult = true;
				} else {
					verifyResult = verifyMobileCode(model, mobile, type, verify);
				}
			} else {
				verifyResult = verifyMobileCode(model, mobile, type, verify);
			}

			if (verifyResult) {
				User user = userService.getObjectById(uid);

				String encodePass = PasswordUtils.encode(newpwd);
				user.setPwd(encodePass);
				boolean result = userService.update(user);

				log.info(mobile + " change password," + newpwd + "result is " + result);
				log.error("rewrite password success! ");

				model.addAttribute("code", 0);
			} else {
				log.error("rewritepwd verifycode");
				model.addAttribute("code", -2005);

				return "/common/success";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}

	//验证码发送
	@RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
	public String sendVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String type) throws ServiceException, ServiceDaoException {
		log.info(mobile + " want send sms of type " + type);

		if (StringUtils.isBlank(mobile)) {
			log.info(mobile + " want send sms of type " + type + " null mobile ");
			model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
			return "/common/success";
		}

		if (StringUtils.isBlank(type)) {
			type = "password";
		}

		if ("register".equals(type)) {
			Long uid = this.userService.getUserIdByMobileAndType(mobile,0);
			if (uid != null) {

				log.info(type + " is already exist  " + mobile);

				model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
				return "/common/success";
			}

		} else {
			Long uid = this.userService.getUserIdByMobileAndType(mobile,0);
			if (uid == null) {

				log.info(type + " is not already exist  " + mobile);

				model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
				return "/common/success";
			}
		}

		int code = InterfaceCodeConstant.System_Success;

		try {
			log.info("sms is start");
			String result = this.smsService.sendMsg(mobile, type);

			switch (result) {
			case SmsService.ErrorCode_SMS_InvalidType:
				code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
				break;
			case SmsService.ErrorCode_SMS_smsMoreThan5:
				code = InterfaceCodeConstant.VerifyCode_MoreThan5;
				break;
			default:

			}

			model.addAttribute("code", code);

		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(mobile + " send message error of type " + type);
			model.addAttribute("code", InterfaceCodeConstant.System_Exception);

		}
		return "/common/success";

	}

	// 语音验证码
	@RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
	public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String type) throws ServiceException, ServiceDaoException {
		log.info(mobile + " want send voice of type " + type);

		if (StringUtils.isBlank(mobile)) {
			log.info(mobile + " want send sms of type " + type + " null mobile ");
			model.addAttribute("code", -2001);
			return "/common/success";
		}
		if (StringUtils.isBlank(type)) {
			type = "password";
		}

		if ("register".equals(type)) {
			Long uid = this.userService.getUserIdByMobileAndType(mobile,0);
			if (uid != null) {
				log.info(type + " is already exist  " + mobile);
				model.addAttribute("code", -2007);
				return "/common/success";
			}
		} else {
			Long uid = this.userService.getUserIdByMobileAndType(mobile,0);
			if (uid == null) {
				log.info(type + " is not already exist  " + mobile);
				model.addAttribute("code", -2000);
				return "/common/success";
			}
		}

		String realMobile = mobile;
		log.info("final mobile is : " + realMobile);

		int code = 0;

		try {
			String result = this.smsService.sendVoice(realMobile, type);
			switch (result) {
			case SmsService.ErrorCode_SMS_InvalidType:
				code = -2003;
				break;
			case SmsService.ErrorCode_SMS_smsMoreThan5:
				code = -2008;
				break;
			case SmsService.ErrorCode_sendError:
				code = -2015;
				break;
			default:

			}

			model.addAttribute("code", code);
		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(mobile + " send voice error of type " + type);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	
	  //修改用户密码
    @RequestMapping(value = "/a/u/pwd", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             String oldPwd, String newPwd)
            throws Exception {
        log.info(" oldPwd = " + oldPwd + " newPwd = " + newPwd);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            log.info(" user : " + uid + " want update pwd");

            if (StringUtil.isEmpty(newPwd) || StringUtils.isEmpty(oldPwd)) {
                log.info("params is null");
                model.addAttribute("code", -2005);
                return "/common/success";
            }

            String pass = PasswordUtils.encode(oldPwd);
            Boolean verify = user.getPwd().equals(pass);
            if (verify) {
                log.info(uid + " have right pwd ");

                String encodePass = PasswordUtils.encode(newPwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

            }
            else {
                log.info(uid + " wrong pwd " + oldPwd);
                model.put("code", -2004);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "密码修改成功");
            return "/common/success1";

        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("user " + uid + " update pwd error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


	/**
	 * 强制更新版本重定向到此请求
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/a/force/update/version", method = RequestMethod.GET)
	public String forceUpdate(HttpServletRequest request, HttpServletResponse response,
														ModelMap model) {
		log.info("method forceUpdate begin...");

		try {
           /*医师*/
			Long constantIdByDoctorCode = constantService.getConstantIdByTypeAndName("doctorCode", "version");
			Long constantIdByDoctorIosCode = constantService.getConstantIdByTypeAndName("doctorIosCode", "version");
			Long constantIdByDoctorAndCode = constantService.getConstantIdByTypeAndName("doctorAndroidCode", "version");
			Long constantIdByDoctorUrl = constantService.getConstantIdByTypeAndName("doctorUrl", "version");
			Long constantIdByDoctorIosName = constantService.getConstantIdByTypeAndName("doctorIosName", "version");
			Long constantIdByDoctorAndroidName = constantService.getConstantIdByTypeAndName("doctorAndroidName", "version");
			Long constantIdByDoctorInfo = constantService.getConstantIdByTypeAndName("doctorInfo", "version");

			if (null != constantIdByDoctorCode && null != constantIdByDoctorUrl) {
				Constant constantByDoctorIosCode = constantService.getObjectById(constantIdByDoctorIosCode);
				Constant constantDoctorByAndCode = constantService.getObjectById(constantIdByDoctorAndCode);
				Constant constantByDoctorCode = constantService.getObjectById(constantIdByDoctorCode);
				Constant constantByDoctorUrl = constantService.getObjectById(constantIdByDoctorUrl);
				Constant constantByDoctorIosName = constantService.getObjectById(constantIdByDoctorIosName);
				Constant constantByDoctorAndroidName = constantService.getObjectById(constantIdByDoctorAndroidName);
				Constant constantByDoctorInfo = constantService.getObjectById(constantIdByDoctorInfo);

				String doctorIosName = constantByDoctorIosName.getValue();
				String doctorAndroidName = constantByDoctorAndroidName.getValue();
				String doctorUrl = constantByDoctorUrl.getValue();
				String doctorVersionCode = constantByDoctorCode.getValue();
				String doctorIosCode = constantByDoctorIosCode.getValue();
				String doctorAndroidCode = constantDoctorByAndCode.getValue();
				String doctorInfo = constantByDoctorInfo.getValue();

				model.addAttribute("doctorUrl", doctorUrl);
				model.addAttribute("doctorIosName", doctorIosName);
				model.addAttribute("doctorAndroidName", doctorAndroidName);
				model.addAttribute("doctorInfo", doctorInfo);
				model.addAttribute("doctorVersionCode", doctorVersionCode);
				model.addAttribute("doctorIosCode", doctorIosCode);
				model.addAttribute("doctorAndroidCode", doctorAndroidCode);

				log.info("get version : doctorIosName =  " + doctorIosName + " doctorAndroidName " + doctorAndroidName + " url = " + doctorUrl +
								" doctorVersionCode = " + doctorVersionCode + " doctorIosCode = " + doctorIosCode + " doctorAndroidCode = " + doctorAndroidCode + " doctorInfo = " + doctorInfo);
			} else {
				log.info("no version");
			}


            /*患者*/
			Long constantIdByPatientCode = constantService.getConstantIdByTypeAndName("patientCode", "version");
			Long constantIdByPatientIosCode = constantService.getConstantIdByTypeAndName("patientIosCode", "version");
			Long constantIdByPatientAndCode = constantService.getConstantIdByTypeAndName("patientAndroidCode", "version");
			Long constantIdByPatientUrl = constantService.getConstantIdByTypeAndName("patientUrl", "version");
			Long constantIdByPatientIosName = constantService.getConstantIdByTypeAndName("patientIosName", "version");
			Long constantIdByPatientAndroidName = constantService.getConstantIdByTypeAndName("patientAndroidName", "version");
			Long constantIdByPatientInfo = constantService.getConstantIdByTypeAndName("patientInfo", "version");

			if (null != constantIdByPatientCode && null != constantIdByPatientUrl) {
				Constant constantByPatientIosCode = constantService.getObjectById(constantIdByPatientIosCode);
				Constant constantPatientByAndCode = constantService.getObjectById(constantIdByPatientAndCode);
				Constant constantByPatientCode = constantService.getObjectById(constantIdByPatientCode);
				Constant constantByPatientUrl = constantService.getObjectById(constantIdByPatientUrl);
				Constant constantByPatientIosName = constantService.getObjectById(constantIdByPatientIosName);
				Constant constantByPatientAndroidName = constantService.getObjectById(constantIdByPatientAndroidName);
				Constant constantByPatientInfo = constantService.getObjectById(constantIdByPatientInfo);

				String patientIosName = constantByPatientIosName.getValue();
				String patientAndroidName = constantByPatientAndroidName.getValue();
				String patientUrl = constantByPatientUrl.getValue();
				String PatientVersionCode = constantByPatientCode.getValue();
				String patientIosCode = constantByPatientIosCode.getValue();
				String patientAndroidCode = constantPatientByAndCode.getValue();
				String patientInfo = constantByPatientInfo.getValue();

				model.addAttribute("patientUrl", patientUrl);
				model.addAttribute("patientIosName", patientIosName);
				model.addAttribute("patientAndroidName", patientAndroidName);
				model.addAttribute("patientInfo", patientInfo);
				model.addAttribute("PatientVersionCode", PatientVersionCode);
				model.addAttribute("patientIosCode", patientIosCode);
				model.addAttribute("patientAndroidCode", patientAndroidCode);

				log.info("get version : patientIosName =  " + patientIosName + " patientAndroidName " + patientAndroidName + " url = " + patientUrl +
								" PatientVersionCode = " + PatientVersionCode + " patientIosCode = " + patientIosCode + " patientAndroidCode = " + patientAndroidCode + " patientInfo = " + patientInfo);
			} else {
				log.info("no version");
			}

			model.addAttribute("code", -9);

		} catch (Exception e) {
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", -9);
			return "/common/success";
		}

		return "/common/versionUpdate";
	}

	/**
	 * 修改用户友盟推送号
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param deviceToken
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/doctor/{deviceToken}/{platform}", method = RequestMethod.PUT)
	public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable String deviceToken, @PathVariable String platform) throws Exception {
		log.info(" update user deviceToken  = " + deviceToken);

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();

		try {

			if(deviceToken.equals(user.getDeviceToken())){
				model.addAttribute("code", 0);
				return "/common/success";
			}else {

				if(StringUtils.isBlank(user.getDeviceToken())){
					log.info("user no device before");
				}else {
					Long startAt = null;
					Long endAt = System.currentTimeMillis() + (7 * 24 * 60 * 60 * 1000);
					log.info(" startAt = " + startAt);

					String result = "";
					String message = "您的账号已于" + dateTime() +
									"在其他设备登录。如非本人操作，则您的密码可能泄漏，请尽快修改密码，或联系客服010-62971892。";
					log.info("message : " + message);
					if ("android".equals(user.getOs())) {
						log.info(" android ");
						result = androidPushServiceImpl.pushMessaeForList("android", "notification", "unicast",
										user.getDeviceToken(), "下线通知", "下线通知", message, "go_app", "", "", "",
										"", startAt, "", "true", endAt, "第九肌肉通知");
						log.info(" anResult = " + result);
					} else if ("ios".equals(user.getOs())) {
						log.info(" ios ");
						result = iosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast",
										user.getDeviceToken(), "下线通知", "下线通知", message, "go_app", "", "", "",
										"", startAt, "", "false", endAt, "第九肌肉通知");
						log.info(" iosResult = " + result);
					} else {
						log.info("user platform : " + user.getOs());
					}

					if (StringUtils.isNotBlank(result)) {
						JSONObject jsonObject = JSONObject.fromObject(result);
						if ("SUCCESS".equals((String) jsonObject.get("ret"))) {
							log.info(" push success ");
						} else {
							log.info("fail" + jsonObject.get("data"));
							JSONObject data = JSONObject.fromObject(jsonObject.get("data").toString());
							log.info(" data = " + data);
							log.info(" errorCode = " + data.get("error_code"));
						}
					} else {
						log.info("user no device before");
					}
				}

				user.setDeviceToken(deviceToken);
				user.setOs(platform);
				userService.update(user);

				model.addAttribute("code", 0);
			}

		} catch (Throwable t) {
			log.error("user logout error  ");
			t.printStackTrace();

		}

		return "/common/success";
	}

	public String dateTime() {
		Long time = System.currentTimeMillis();
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date = format.format(time);
		return date;
	}

}
