package com.ptteng.muscle.main.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.common.muscle.model.*;
import com.ptteng.common.muscle.service.*;
import com.ptteng.muscle.main.model.Constant;
import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.model.ProgramRelation;
import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.main.service.ConstantService;
import com.ptteng.muscle.main.service.DoctorService;
import com.ptteng.muscle.main.service.ProgramRelationService;
import com.ptteng.muscle.main.service.UserService;
import com.ptteng.muscle.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.sun.java.browser.net.ProxyService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.util.StringUtil;
import com.ptteng.muscle.main.model.Patient;
import com.ptteng.muscle.main.service.PatientService;

/**
 * Patient crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PatientController {
	private static final Log log = LogFactory.getLog(PatientController.class);

	@Autowired
	private PatientService patientService;
	@Autowired
	private UserService userService;
	@Autowired
	private DoctorService doctorService;

	@Autowired
	private ProgramRelationService programRelationService;
  @Autowired
  private ConstantService constantService;

  @Autowired
  private SensitivityReportService sensitivityReportService;
  @Autowired
  private HardnessDetectionService hardnessDetectionService;
  @Autowired
  private HardnessReportService hardnessReportService;
  @Autowired
  private HardnessReportRootService hardnessReportRootService;
  @Autowired
  private TemperatureCheckService temperatureCheckService;
  @Autowired
  private TemperatureCheckStemService temperatureCheckStemService;
  @Autowired
  private BloodFlowReportService bloodFlowReportService;

	/**
	 * 患者详情
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/patient/{id}", method = RequestMethod.GET)
	public String getPatientJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get patient id is  " + id);
		try {
			Patient patient = patientService.getObjectById(id);

			if (DataUtils.isNullOrEmpty(patient)) {
				log.info("patient is null");
				model.addAttribute("code", -2000);
				return "/common/success";
			}else{
				log.info("patient id : " + id + " exist !");
			}
			User user = userService.getObjectById(id);
			
			if (DataUtils.isNullOrEmpty(user)) {
				log.info("user is null");
				model.addAttribute("code", -2000);
				return "/common/success";
			}else{
				log.info("user id : " + id + " exist !");
			}

			model.addAttribute("code", 0);
			model.addAttribute("user", user);
			model.addAttribute("patient", patient);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get patient error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/patient/json/patientDetailJson";
	}
	
	

	//我的方案
    @RequestMapping(value = "/a/u/program/list", method = RequestMethod.GET)
    public String getProgramRelation(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Integer page,
                                     Integer size, Long pid) throws Exception {

        log.info("=======get program list=======");
        log.info("pid is :" + pid);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;
        Integer total = 0;


        try {

            List<ProgramRelation> programRelationList = new ArrayList<>();
            Map<String, Object> params = DynamicUtil.getProgramRelationQueryListParam(pid, false);
            log.info("dynamic params is :" + params);
            List<Long> ids = programRelationService.getIdsByDynamicCondition(ProgramRelation.class, params, start, size);
            log.info("dynamic params get ids is :" + ids);
            if (CollectionUtils.isNotEmpty(ids)) {
                programRelationList = programRelationService.getObjectsByIds(ids);
                if (ids.size() >= size) {
                    next = true;
                } else {
                    next = false;
                }
            } else {
                log.info("pid is " + pid + " get null programList;");
            }

            Map<String, Object> countParams = DynamicUtil.getProgramRelationQueryListParam(pid, true);
            log.info("dynamic get countParams is :" + countParams);
            List<Long> totalList = programRelationService.getIdsByDynamicCondition(ProgramRelation.class, countParams, 0, Integer.MAX_VALUE);
            log.info("dynamic countParams get totalList is :" + totalList);
            if (CollectionUtils.isNotEmpty(totalList)) {
                total = totalList.get(0).intValue();
                log.info("total is :" + total);
            } else {
                total = 0;
                log.info("total is :" + 0);
            }

            log.info("=======get programList's list doctor info=======");
            Set<Long> dids = new HashSet<>();
            for (ProgramRelation programRelation : programRelationList) {
                dids.add(programRelation.getDid());
            }
            log.info("programRelationList get dids is :" + dids);
            List<Doctor> doctorList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(dids)) {
                doctorList = doctorService.getObjectsByIds(new ArrayList<>(dids));
            } else {
                log.info("programRelationList get dids is :" + dids);
            }


            log.info("=======get program price=======");
            /* 方案价格 */
            /* 动态查询-获取参数列表 */
            Map<String, Object> paramList = DynamicUtil.getConstantProgramParam();
            log.info("dynamic paramList is :" + paramList);
            //获取list
            List<Long> constantIdList = constantService.getIdsByDynamicCondition(Constant.class, paramList, 0, 1);
            log.info("dynamic paramsList get costantIdList is :" + constantIdList);
            Constant constant = new Constant();
            if (CollectionUtils.isEmpty(constantIdList)) {
                log.info("dynamic paramslist get costantIdList is :" + constantIdList);
            } else {
                log.info("dynamic paramslist get costantIdList is :" + constantIdList);
                Long constantId = constantIdList.get(0);
                log.info("constantId is :" + constantId);
                constant = constantService.getObjectById(constantId);
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("programRelationList", programRelationList);
            model.addAttribute("doctorList", doctorList);
            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get hospital list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/muscle-main-service/programRelation/json/programRelationList";
    }

  /*检测数据列表*/
  @RequestMapping(value = "/a/u/detection/list", method = RequestMethod.GET)
  public String getDetetionData(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                                Integer size,Long pid,Long createFrom, Long createTo) throws Exception {
    if (page == null) {
      page = 1;
    }
    if (size == null) {
      size = 10;
    }
    int start = (page - 1) * size;
    if (start < 0) {
      start = 0;
    }

    boolean next = false;

    Integer total = 0;


    try {

      Patient patient = patientService.getObjectById(pid);
      if (DataUtils.isNullOrEmpty(patient)) {
        log.info("this patient is null");
        model.addAttribute("code", -2000);
        return "/common/success";
      }

      User user = userService.getObjectById(pid);
      if (DataUtils.isNullOrEmpty(user)) {
        log.info("this user is null");
        model.addAttribute("code", -2000);
        return "/common/success";
      }

      String mobile = user.getMobile();


			/*敏感度头部报告*/
      List<SensitivityReport> sensitivityReports = new ArrayList<>();
      Map<String,Object> params = DynamicUtil.getSensitityReportQuery(createFrom,createTo,mobile,false);
      log.info("sensitityReport get dynamic params is :" + params);
      List<Long> sensitivityReportList = sensitivityReportService.getIdsByDynamicCondition(SensitivityReport.class, params, start, size);
      log.info("sensitityReport dynamic get ids is :" + sensitivityReportList);
      if (CollectionUtils.isNotEmpty(sensitivityReportList)) {
        sensitivityReports = sensitivityReportService.getObjectsByIds(sensitivityReportList);
        if (sensitivityReportList.size() >= size) {
          sensitivityReports = sensitivityReports.subList(0, size);
          next = true;
        }
      }

      Map<String,Object> paramCount = DynamicUtil.getSensitityReportQuery(createFrom,createTo,mobile,true);
      log.info("sensitityReport get dynamic params is :" + paramCount);
      List<Long> countList = sensitivityReportService.getIdsByDynamicCondition(SensitivityReport.class, paramCount, 0, Integer.MAX_VALUE);

      if (CollectionUtils.isNotEmpty(countList)) {
        total = countList.get(0).intValue();
      }

			/*寻找血流报告*/
      List<String> bloodFlowTime = new ArrayList<>();
      for (SensitivityReport sensitivityReport : sensitivityReports) {
        bloodFlowTime.add(sensitivityReport.getDetectionAt());
      }
      log.info("sensitity report get detection time is :" + bloodFlowTime);

      StringBuffer stringBuffer = new StringBuffer();
      int i = 0;
      if (CollectionUtils.isNotEmpty(bloodFlowTime)) {
        for (String s : bloodFlowTime) {
          i++;
          stringBuffer.append("'"+s + "'");
          if (bloodFlowTime.size() > i) {
            stringBuffer.append(",");
          }
        }
      }

      log.info("blowFlowTime list get StringBuffer :" + stringBuffer);
      log.info("sensitivity report get mobile is :" + mobile);
      Map<String,Object> paramGetBloodFlow = DynamicUtil.getBloodFlowQuery(stringBuffer,mobile);
      log.info("paramGetBloodFlow is :" + paramGetBloodFlow);
      List<Long> bloodFlowReportDetectionIds = bloodFlowReportService.getIdsByDynamicCondition(BloodFlowReport.class, paramGetBloodFlow, start, size);
      log.info("dynamic get bloodFlowReport detection ids is :" + bloodFlowReportDetectionIds);
      List<BloodFlowReport> bloodFlowReports = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(bloodFlowReportDetectionIds)) {
        bloodFlowReports = bloodFlowReportService.getObjectsByIds(bloodFlowReportDetectionIds);
      }

			/*寻找最强硬度*/
			/*头部rau*/
      List<HardnessReport> hardnessReportRau = new ArrayList<>();
      Map<String, Object> hardessReportParams = DynamicUtil.getHardessQuery(stringBuffer, mobile);
      log.info("hardessReportParams params is :" + hardessReportParams);
      List<Long> hardessIds = hardnessReportService.getIdsByDynamicCondition(HardnessReport.class, hardessReportParams, start, size);
      log.info("dynamic hardessReportParams params get ids is :" + hardessIds);
      if (CollectionUtils.isNotEmpty(hardessIds)) {
        hardnessReportRau = hardnessReportService.getObjectsByIds(hardessIds);
      }

			/*头部tau*/
      List<HardnessReport> hardnessReportTau = new ArrayList<>();
      Map<String, Object> hardessTauReportParams = DynamicUtil.getHardessTauQuery(stringBuffer, mobile);
      log.info("hardessReportParams params is :" + hardessTauReportParams);
      List<Long> hardessTauIds = hardnessReportService.getIdsByDynamicCondition(HardnessReport.class, hardessTauReportParams, start, size);
      log.info("dynamic hardessTauIds params get ids is :" + hardessTauIds);
      if (CollectionUtils.isNotEmpty(hardessTauIds)) {
        hardnessReportTau = hardnessReportService.getObjectsByIds(hardessTauIds);
      }


			/*根部rau*/
      List<HardnessReportRoot> hardnessReportRootRau = new ArrayList<>();
      Map<String, Object> hardessReportRootParams = DynamicUtil.getHardessReportRootQuery(stringBuffer, mobile);
      log.info("hardessReportRootParams params is :" + hardessReportRootParams);
      List<Long> hardessRootIds = hardnessReportRootService.getIdsByDynamicCondition(HardnessReportRoot.class, hardessReportRootParams, start, size);
      log.info("dynamic hardessRootIds params get ids is :" + hardessRootIds);
      if (CollectionUtils.isNotEmpty(hardessRootIds)) {
        hardnessReportRootRau = hardnessReportRootService.getObjectsByIds(hardessRootIds);
      }

			/*根部tau*/
      List<HardnessReportRoot> hardnessReportRootTau = new ArrayList<>();
      Map<String, Object> hardessReportRootTauParams = DynamicUtil.getHardessReportRootTauQuery(stringBuffer, mobile);
      log.info("hardessReportRootTauParams params is :" + hardessReportRootTauParams);
      List<Long> hardessRootTauIds = hardnessReportRootService.getIdsByDynamicCondition(HardnessReportRoot.class, hardessReportRootTauParams, start, size);
      log.info("dynamic hardessRootTauIds params get ids is :" + hardessRootTauIds);
      if (CollectionUtils.isNotEmpty(hardessRootTauIds)) {
        hardnessReportRootTau = hardnessReportRootService.getObjectsByIds(hardessRootTauIds);
      }

      model.addAttribute("code", 0);
      model.addAttribute("page", page);
      model.addAttribute("size", size);
      model.addAttribute("next", next);
      model.addAttribute("total", total);
      model.addAttribute("sensitivityReports", sensitivityReports);
      model.addAttribute("bloodFlowReports", bloodFlowReports);
      model.addAttribute("hardnessReportRau", hardnessReportRau);
      model.addAttribute("hardnessReportTau", hardnessReportTau);
      model.addAttribute("hardnessReportRootRau", hardnessReportRootRau);
      model.addAttribute("hardnessReportRootTau", hardnessReportRootTau);

    } catch (Throwable t) {
      t.printStackTrace();
      log.error(t.getMessage());
      log.error("get comment list error,page is  " + start + " , size "
              + size);
      // for test
      model.addAttribute("code", -100000);
    }

    return "/muscle-main-service/sensitivityReport/json/sensitivityReportListJson";
  }


  /*检测数据详情*/
  @RequestMapping(value = "/a/u/detection/{id}", method = RequestMethod.GET)
  public String getDetetionDataDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {


    log.info("/a/u/detection/{id} put id is :" + id);

    try {


      SensitivityReport sensitivityReport = sensitivityReportService.getObjectById(id);
      if (DataUtils.isNullOrEmpty(sensitivityReport)) {
        log.info("this sensitivityReport is not exist");
        model.addAttribute("code", -23016);
        return "/common/success";
      }

      String detetionData = sensitivityReport.getDetectionAt();
      String mobile = sensitivityReport.getMobile();

			/*硬度检测*/
      Map<String, Object> hardnessDetectionParam = DynamicUtil.getHardnessDetectionQuery(detetionData, mobile);
      log.info("hardness detectioin params is :" + hardnessDetectionParam);
      List<Long> hardnessDetectionIds = hardnessDetectionService.getIdsByDynamicCondition(HardnessDetection.class, hardnessDetectionParam, 0, Integer.MAX_VALUE);
      log.info("hardness detection dynamic get ids is :" + hardnessDetectionIds);
      List<HardnessDetection> hardnessDetections = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(hardnessDetectionIds)) {
        hardnessDetections = hardnessDetectionService.getObjectsByIds(hardnessDetectionIds);
      }

			/*硬度检测报告 头部*/
      List<HardnessReport> hardnessReportList = new ArrayList<>();
      Map<String, Object> hardessReportParams = DynamicUtil.getHardessReportQuery(detetionData, mobile);
      log.info("hardessReportParams params is :" + hardessReportParams);
      List<Long> hardessIds = hardnessReportService.getIdsByDynamicCondition(HardnessReport.class, hardessReportParams, 0, Integer.MAX_VALUE);
      log.info("dynamic hardessReportParams params get ids is :" + hardessIds);
      if (CollectionUtils.isNotEmpty(hardessIds)) {
        hardnessReportList = hardnessReportService.getObjectsByIds(hardessIds);
      }


			/*硬度检测报告 根部*/
      List<HardnessReportRoot> hardnessReportRootList = new ArrayList<>();
      Map<String, Object> hardessReportRootParams = DynamicUtil.getHardessReportRootTQuery(detetionData, mobile);
      log.info("hardessReportRootParams params is :" + hardessReportRootParams);
      List<Long> hardessRootIds = hardnessReportRootService.getIdsByDynamicCondition(HardnessReportRoot.class, hardessReportRootParams, 0, Integer.MAX_VALUE);
      log.info("dynamic hardessReportRootParams params get ids is :" + hardessRootIds);
      if (CollectionUtils.isNotEmpty(hardessRootIds)) {
        hardnessReportRootList = hardnessReportRootService.getObjectsByIds(hardessRootIds);
      }

			/*敏感度报告*/
      List<SensitivityReport> sensitivityReports = new ArrayList<>();
      Map<String,Object> paramsSensitivityReport = DynamicUtil.getSensitityQuery(detetionData, mobile);
      log.info("sensitivity report get params is :" +paramsSensitivityReport);
      List<Long> sensitivityIds = sensitivityReportService.getIdsByDynamicCondition(SensitivityReport.class, paramsSensitivityReport, 0, Integer.MAX_VALUE);
      log.info("sensitivity report dynamic get ids is :" + sensitivityIds);
      if (CollectionUtils.isNotEmpty(sensitivityIds)) {
        sensitivityReports = sensitivityReportService.getObjectsByIds(sensitivityIds);
      }

			/*血流报告*/
      Map<String,Object> paramGetBloodFlow = DynamicUtil.getBloodFlowRQuery(detetionData,mobile);
      log.info("paramGetBloodFlow is :" + paramGetBloodFlow);
      List<Long> bloodFlowReportDetectionIds = bloodFlowReportService.getIdsByDynamicCondition(BloodFlowReport.class, paramGetBloodFlow, 0, Integer.MAX_VALUE);
      log.info("dynamic get bloodFlowReport detection ids is :" + bloodFlowReportDetectionIds);
      List<BloodFlowReport> bloodFlowReports = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(bloodFlowReportDetectionIds)) {
        bloodFlowReports = bloodFlowReportService.getObjectsByIds(bloodFlowReportDetectionIds);
      }

			/*敏感度头部检测数据*/
      List<TemperatureCheck> temperatureChecks = new ArrayList<>();
      Map<String,Object> paramsTemperatureCheck = DynamicUtil.getTemperatureChecksQuery(detetionData, mobile);
      log.info("paramsTemperatureCheck  get params is :" +paramsTemperatureCheck);
      List<Long> temperatureCheckIds = temperatureCheckService.getIdsByDynamicCondition(TemperatureCheck.class, paramsTemperatureCheck, 0, Integer.MAX_VALUE);
      log.info("sensitivity report dynamic get ids is :" + temperatureCheckIds);
      if (CollectionUtils.isNotEmpty(temperatureCheckIds)) {
        temperatureChecks = temperatureCheckService.getObjectsByIds(temperatureCheckIds);
      }

			/*敏感度根部检测数据*/
      List<TemperatureCheckStem> temperatureCheckStems = new ArrayList<>();
      Map<String,Object> paramsTemperatureCheckStems = DynamicUtil.getTemperatureChecksStemQuery(detetionData, mobile);
      log.info("paramsTemperatureCheckStems  get params is :" +paramsTemperatureCheckStems);
      List<Long> temperatureCheckStemsIds = temperatureCheckStemService.getIdsByDynamicCondition(TemperatureCheckStem.class, paramsTemperatureCheckStems, 0, Integer.MAX_VALUE);
      log.info("sensitivity report dynamic get ids is :" + temperatureCheckStemsIds);
      if (CollectionUtils.isNotEmpty(temperatureCheckStemsIds)) {
        temperatureCheckStems = temperatureCheckStemService.getObjectsByIds(temperatureCheckStemsIds);
      }

      model.addAttribute("code", 0);
      model.addAttribute("hardnessDetections", hardnessDetections);
      model.addAttribute("hardnessReportList", hardnessReportList);
      model.addAttribute("hardnessReportRootList", hardnessReportRootList);
      model.addAttribute("sensitivityReports", sensitivityReports);
      model.addAttribute("bloodFlowReports", bloodFlowReports);
      model.addAttribute("temperatureChecks", temperatureChecks);
      model.addAttribute("temperatureCheckStems", temperatureCheckStems);


    } catch (Throwable t) {
      t.printStackTrace();
      log.error(t.getMessage());
      model.addAttribute("code", -100000);
    }

    return "/muscle-main-service/sensitivityReport/json/sensitivityReportDetailJson";
  }

}
