package com.ptteng.muscle.main.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.model.Orders;
import com.ptteng.muscle.main.service.OrderService;
import com.ptteng.muscle.util.DynamicUtil;

import java.util.List;
import java.util.Map;


/**
 * 医师端-订单部分
 */
@Controller
public class OrderController {
	private static final Log log = LogFactory.getLog(OrderController.class);

	@Autowired
	private OrderService orderService;






	/**
	 * 查询订单列表
	 * @param did - 医师id
	 * @param status - 支付状态
	 * @throws Exception
	 * */
	@RequestMapping(value = "a/u/order/list", method = RequestMethod.GET)
	public String readOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
								Long did, Integer status, Integer page, Integer size) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		if (null == did) {
			model.addAttribute("code", -22001);
			return "common/success";
		} else {
			log.info("get order list, did is: " + did + ". status is: " + status);
		}


		try {
			Map<String, Object> param = DynamicUtil.getOrderQueryListParam(did, status, false);
			List<Long> ids = orderService.getIdsByDynamicCondition(Orders.class, param, start, size);
			List<Orders> orderList = orderService.getObjectsByIds(ids);

			Map<String, Object> paramCount = DynamicUtil.getOrderQueryListParam(did, status, true);
			List<Long> idsCount = orderService.getIdsByDynamicCondition(Orders.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = idsCount.get(0).intValue();

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("orderList", orderList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get orders error");
			model.addAttribute("code", -22000);
		}

		return "muscle-main-service/order/json/orderListJson";

	}

}

