package com.ptteng.muscle.main.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.model.Comment;
import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.main.service.CommentService;
import com.ptteng.muscle.main.service.UserService;
import com.ptteng.muscle.util.DynamicUtil;
import com.qding.common.util.DataUtils;

/**
 * Comment crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CommentController {
	private static final Log log = LogFactory.getLog(CommentController.class);

	@Autowired
	private CommentService commentService;

	@Autowired
	private UserService userService;

	/* 评论列表 */
	@RequestMapping(value = "/a/u/comment/list", method = RequestMethod.GET)
	public String getCommentIdsByDidOrderByCommentAtJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size, Long did, Long pid) throws Exception {

		log.info("======== search doctor comment List===========");
		log.info("doctor id is: " + did + "patient id is: " + pid);
		
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Integer total = 0;
		boolean next = false;
		log.info("pageList : page= " + start + " , size=" + size);
		
		if (DataUtils.isNullOrEmpty(did)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

		try {

			List<Long> ids = new ArrayList<>();
			List<Long> totalList = new ArrayList<>();
			List<Comment> commentList = new ArrayList<>();

			Map<String, Object> params = DynamicUtil.getCommentQueryParam(did, pid, false);
			log.info("commont dynamic sql is " + params);
			
			ids = commentService.getIdsByDynamicCondition(Comment.class, params, start, size);
			log.info("commont ids is: " + ids);
			
			if (DataUtils.isNotNullOrEmpty(ids)) {
				commentList = commentService.getObjectsByIds(ids);
				if (commentList.size() >= size) {
					commentList = commentList.subList(0, size);
					next = true;
				}
			}else{
				log.info("commont ids is:" + ids +"data null");
			}

			Map<String, Object> paramsCount = DynamicUtil.getCommentQueryParam(did, pid, true);
			totalList = commentService.getIdsByDynamicCondition(Comment.class, paramsCount, 0, Integer.MAX_VALUE);

			if (DataUtils.isNotNullOrEmpty(totalList)) {
				total = totalList.get(0).intValue();
				log.info("total number is  " + total);
			}else{
				log.info("totalList is null");
			}

			List<User> patientList = new ArrayList<>();
			List<User> doctorList = new ArrayList<>();
			Set<Long> pids = new HashSet<>();
			Set<Long> dids = new HashSet<>();
			
			/*遍历出患者id和医师id*/
			for (Comment comment : commentList) {
				pids.add(comment.getPid());
				dids.add(comment.getDid());
			}

			if (DataUtils.isNotNullOrEmpty(pids)) {
				patientList = userService.getObjectsByIds(new ArrayList<Long>(pids));
			}else{
				log.info("patient pids is " + pids + "data null");
			}
			if (DataUtils.isNotNullOrEmpty(dids)) {
				doctorList = userService.getObjectsByIds(new ArrayList<Long>(dids));
			}else{
				log.info("doctor dids is " + dids + "data null");
			}

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("next", next);
			model.addAttribute("total", total);
			model.addAttribute("patientList", patientList);
			model.addAttribute("doctorList", doctorList);
			model.addAttribute("commentList", commentList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get comment list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/comment/json/commentListJson";
	}

	
	/* 新增评价医师 */
	@RequestMapping(value = "/a/u/comment", method = RequestMethod.POST)
	public String addCommentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long did,
			Long pid, Integer star, String comment) throws Exception {

		if (DataUtils.isNullOrEmpty(did)) {
			log.info("did is null");
			model.addAttribute("code", -23001);
			return "/common/success";
		}

		if (DataUtils.isNullOrEmpty(pid)) {
			log.info("pid is null");
			model.addAttribute("code", -23002);
			return "/common/success";
		}

		if (DataUtils.isNullOrEmpty(star)) {
			log.info("star is null");
			model.addAttribute("code", -23003);
			return "/common/success";
		}

		if (DataUtils.isNullOrEmpty(comment)) {
			log.info("comment is null");
			model.addAttribute("code", -23004);
			return "/common/success";
		}
		try {
			Comment cmt = new Comment();
			cmt.setComment(comment);
			cmt.setCommentAt(System.currentTimeMillis());
			cmt.setDid(did);
			cmt.setPid(pid);
			cmt.setStar(star);
			Long id = commentService.insert(cmt);
			model.addAttribute("id", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add comment error ");
			model.addAttribute("code", -6002);
		}

		return "/common/insert";
	}
	
}
