package com.ptteng.muscle.interceptor;

import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.main.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class UserInterceptor extends HandlerInterceptorAdapter {


    private static final Log log = LogFactory.getLog(UserInterceptor.class);

    @Autowired
    private UserService userService;

    public static String SPLITTER_REGEX = "\\|";

    public static final String USER_ID = "userId";

    @Autowired
    private CookieUtil cookieUtil;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {

        // 把所有的请求参数打出来
        log.info(" request uri: " + request.getRequestURI());
        log.info("request token" + request.getHeader("token"));
        Enumeration<String> names = request.getParameterNames();
        log.info("=========================================" + request.getParameter("token"));
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String value = request.getParameter(name);
            log.info(" Parameter  name : " + name + " value : " + value);
        }
        //

        String token = request.getParameter("token");
        if (null == token) {
            token = request.getHeader("token");
        }
        log.info("token : " + token);
        if (null != token) {
            Map map = decodeCookie(token);
            log.info("map is : " + map);
            Long uid = null;
            User user = null;
            if (null != map) {
                uid = (Long) map.get(USER_ID);
                log.info("uid is : " + uid);
            }
            else {
                log.info("maps is null");
                return noLogin(response, request);
            }
            if (null != uid) {
                user = this.userService.getObjectById(uid);
                log.info("user is : " + user);
                if (null != user) {
                    if (User.STATUS_OFF.equals(user.getStatus())) {
                        return userOff(response, request);
                    }
                    request.setAttribute("user", user);
                }
                else {
                    log.info("user is null");
                    return noLogin(response, request);
                }

            }
            else {
                log.info("uid is null");
                return noLogin(response, request);
            }
        }
        else {
            Long uid = cookieUtil.getID(request);
            log.info("uid is " + uid);
            if (uid == null) {
                return noLogin(response, request);
            }
            log.info("get uid  from cookie is " + uid);
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                return noLogin(response, request);
            }
            else {
                if (User.STATUS_OFF.equals(user.getStatus())) {
                    return userOff(response, request);
                }
                log.info("get usr " + user);
                request.setAttribute("user", user);
            }
            log.info("get uid is " + uid);
            return true;
        }
        return true;
    }

    public static Map getUserIdentity(String userName, Long userId) {
        Map map = new HashMap();
        map.put(CookieUtil.USER_NAME, userName);
        map.put(CookieUtil.USER_ID, userId);
        return map;
    }

    private Map decodeCookie(String value) {
        if (StringUtils.isBlank(value))
            return null;
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
            Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
            if (userId.equals(uid)) {
                return getUserIdentity(userName, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Wrong cookie format: [" + value + "] message is:" + e.getMessage());
            return null;
        }

        return null;
    }

    private boolean userOff(HttpServletResponse response, HttpServletRequest request)
            throws IOException {

        log.info(" user is  freeze");

        RequestDispatcher rd = request.getRequestDispatcher("/r/json/statusOff.json");
        try {
            rd.forward(request, response);
        }
        catch (ServletException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;

    }

    // 用户未登录
    private boolean noLogin(HttpServletResponse response, HttpServletRequest request)
            throws IOException {

        log.info(" user don't login");

        RequestDispatcher rd = request.getRequestDispatcher("/r/json/noLogin.json");
        try {
            rd.forward(request, response);
        }
        catch (ServletException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;

    }

    private boolean wrongUser(HttpServletResponse response, String token) throws IOException {

        response.sendRedirect("/a/wrong/" + token);
        return false;

    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView)
            throws Exception {

        log.info("p =========================================== ");
    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI()
                + (null == request.getQueryString() ? "" : "?" + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");

        log.info("get getInterceptorUrl is " + interceptorUrl);

        return interceptorUrl;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String value = "158|b312db2d21e59d36fefa868d6f0facd4*AGDt8TIx56z8-JG-30bQ_ZWXZmcIBq4biS2y4KMyloc";
        String[] p = value.split(SPLITTER_REGEX);
        log.info("======"+p);
        Long userId = new Long(p[0]);
        String crypt = p[1];
        String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
        String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
        Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
        log.info(uid);
        log.info(userId);
        if (userId.equals(uid)) {
            log.info("token wrong");
            System.out.print(getUserIdentity(userName, userId));
        }

        // String x = URLEncoder.encode("p/hello", "utf-8");
        // log.info(x);

    }
}
