package com.ptteng.muscle.main.controller;


import com.ptteng.muscle.common.model.Message;
import com.ptteng.muscle.common.model.Version;
import com.ptteng.muscle.common.service.VersionService;
import com.ptteng.muscle.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@Controller
public class VersionController {
    private static final Log log = LogFactory.getLog(VersionService.class);

    @Autowired
    private VersionService versionService;

    @RequestMapping(value = "/a/u/version/list", method = RequestMethod.GET)
    public String getVersionList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                 Integer page, Integer size, String app, String platform) throws Exception {

        log.info("get /a/u/version/list params, app: " + app + ", platform: " + platform);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            // 获取message
            Map<String, Object> versionParams = DynamicUtil.getVersionParams(app, platform, false);
            List<Long> ids = versionService.getIdsByDynamicCondition(Message.class, versionParams, start, size);
            log.info("get version list ids is: " + ids);

            Map<String, Object> versionParamsTotal = DynamicUtil.getVersionParams(app, platform, true);
            List<Long> idsTotal = versionService.getIdsByDynamicCondition(Message.class, versionParamsTotal, 0, Integer.MAX_VALUE);
            Integer total = idsTotal.get(0).intValue();
            log.info("get version list total is: " + total);

            if (CollectionUtils.isEmpty(ids)){
                log.info(" get version ids size is 0 ");
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", 0);
                model.addAttribute("data", "[]");
                return "/muscle-main-service/version/versionListJson";
            }else {
                log.info(" get version ids size is  " + ids.size());
            }
            List<Version> versionList = versionService.getObjectsByIds(ids);
            log.info("get version list size is: " + versionList.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("versionList", versionList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get version list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/muscle-main-service/version/versionListJson";

    }
}
