package com.ptteng.muscle.main.controller;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.muscle.main.model.*;
import com.ptteng.muscle.common.model.Sms;
import com.ptteng.muscle.main.service.*;
import com.qding.common.util.http.cookie.IdentityUtil;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.service.EquipmentService;
import com.ptteng.muscle.common.service.SmsService;
import com.ptteng.muscle.constant.InterfaceCodeConstant;
import com.ptteng.muscle.interceptor.CookieConstant;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * User crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);

	@Autowired
	private UserService userService;
	@Autowired
	private SmsService smsService;

	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private DoctorService doctorService;
	@Autowired
	private EquipmentService equipmentService;

	@Autowired
	private EquipmentRelationService equipmentRelationService;

	@Resource(name = "accountConfig")
	private Map<String, String> accountConfig;

	/* 医师登录 */
	@RequestMapping(value = "/a/doctor/login", method = RequestMethod.POST)
	public String login(HttpServletRequest request, HttpServletResponse response, ModelMap mapModel, String mobile,
			String pwd, String model, String os, String version, String device_token) throws Exception {

		log.info("Doctor login is "+"mobile " + mobile + "password " + pwd);

		if (mobile == null) {
			mapModel.addAttribute("code", -1000);
			return "/common/success";
		}
		
		Long uid = userService.getUserIdByMobile(mobile);
		String token = IdentityUtil.encodeCookie("phone", uid);

		if (uid == null) {
			mapModel.addAttribute("code", -2000);
			return "common/success";
		}
		log.info("uid is " + uid);
		User user = this.userService.getObjectById(uid);
		
		/*
		if (user.getType() != User.DOCTOR_TYPE){
			mapModel.addAttribute("code", -2000);
			return "common/success";
		}
		*/
		
		String pass = PasswordUtils.encode(pwd);
		Boolean verify = user.getPwd().equals(pass);

		if (verify) {
			log.info(uid + " login ");
			Map<String, String> maps = new HashMap();

			maps.put(CookieUtil.USER_ID, uid + "");
			maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
			cookieUtil.setIdentity(request, response, maps, uid);

			/* 判断是否添加过该设备 */
			Long equmpentIdd = equipmentService.getEquipmentByDeviceToken(device_token);
			if (DataUtils.isNullOrEmpty(equmpentIdd)) {
				Equipment equipment = new Equipment();
				equipment.setModel(model);
				equipment.setVersion(version);
				equipment.setOs(os);
				equipment.setDeviceToken(device_token);
				equipmentService.insert(equipment);

				Long eid = equipmentService.getEquipmentByDeviceToken(device_token);
				/* 创建存储对象 */
				EquipmentRelation equipmentRelation = new EquipmentRelation();
				equipmentRelation.setUid(uid);
				equipmentRelation.setEid(eid);

				equipmentRelationService.update(equipmentRelation);
				mapModel.addAttribute("code", "0");
				mapModel.addAttribute("message", "success");
				log.info("add equipmentRelation success .  uid = " + uid + " eid = " + eid);
			}

			mapModel.addAttribute("code", 0);
			mapModel.addAttribute("uid", uid);
			mapModel.addAttribute("token", token);
			mapModel.addAttribute("deviceToken", device_token);
			mapModel.addAttribute("model", model);
			mapModel.addAttribute("mobile", mobile);
		} else {
			log.info(mobile + " wrong pwd " + pwd);
			mapModel.put("code", -2004);
			return "/common/success";
		}

		return "/muscle-main-service/user/json/login";
	}

	/* 医师注册 */
	@RequestMapping(value = "/a/doctor/register", method = RequestMethod.POST)
	public String register(HttpServletRequest request, HttpServletResponse response, ModelMap mapModel, String mobile,
			String pwd, String verify, String idcard, String model, String os, String version, String device_token)
					throws Exception {

		log.info("mobile is " + mobile + "pwd is " + pwd + "verify is " + verify + "idcard is " + idcard);

		String type = "register";

		if (StringUtils.isEmpty(mobile)) {
			mapModel.addAttribute("code", -1000);
			return "/common/success";
		}

		if (StringUtils.isEmpty(verify)) {
			mapModel.addAttribute("code", -1000);
			return "/common/success";
		}

		if (StringUtils.isEmpty(pwd)) {
			mapModel.addAttribute("code", -1000);
			return "/common/success";
		}

		try {
			/* 是否已注册 */
			Long uid1 = userService.getUserIdByMobile(mobile);
			if (uid1 != null) {
				log.info(mobile + " is already exist  " + uid1);
				mapModel.addAttribute("code", -2007);
				mapModel.addAttribute("message", -2007);
				return "/common/success";
			} else {
				log.info(mobile + " not exist ,so can register ");
			}
			boolean verifyResult = false;

			if (verifyModel()) {
				log.info("is test model ");
				if ("555555".equals(verify)) {
					log.info("test ,so not verify mobile ");
					verifyResult = true;
				} else {
					log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
					verifyResult = verifyMobileCode(mapModel, mobile, type, verify);
				}
			} else {
				log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
				verifyResult = verifyMobileCode(mapModel, mobile, type, verify);
			}
			/* 校验验证码 */
			Long now = System.currentTimeMillis();
			SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyyMMdd");
			String date = myFmt2.format(now);
			if (verifyResult) {
				User user = new User();
				user.setMobile(mobile);
				user.setStatus(0);
				String encodePass = PasswordUtils.encode(pwd);
				user.setPwd(encodePass);
				/* 类型为医师对象 */
				user.setType(0);
				Long userID = userService.insert(user);

				Doctor doctor = new Doctor();
				doctor.setId(userID);
				doctorService.insert(doctor);

				/* 判断是否添加过该设备 */
				Long equmpentIdd = equipmentService.getEquipmentByDeviceToken(device_token);
				if (DataUtils.isNotNullOrEmpty(equmpentIdd)) {
					log.info("add equipment success");
				} else {

					Equipment equipment = new Equipment();

					equipment.setModel(model);
					equipment.setVersion(version);
					equipment.setOs(os);
					equipment.setDeviceToken(device_token);
					equipmentService.insert(equipment);
				}

				Long uid = userService.getUserIdByMobile(mobile);
				Long eid = equipmentService.getEquipmentByDeviceToken(device_token);
				
				/* 先查询是否添加过该条数据 uid和eid是否有匹配数据 */
				Long tempId = equipmentRelationService.getEquipmentRelationByUidAndEid(uid, eid);
				log.info("tempid == " + tempId);
				if (DataUtils.isNotNullOrEmpty(tempId)) {

					log.info("object is exit");
					mapModel.addAttribute("code", 0);
					mapModel.addAttribute("message", -5072);
					return "/common/success";
				}

				/* 存储设备关系对象 */
				EquipmentRelation equipmentRelation = new EquipmentRelation();
				equipmentRelation.setUid(uid);
				equipmentRelation.setEid(eid);

				equipmentRelationService.insert(equipmentRelation);
				mapModel.addAttribute("code", "0");
				mapModel.addAttribute("message", "success");
				log.info("add equipmentRelation success .  uid = " + uid + " eid = " + eid);

				String token = IdentityUtil.encodeCookie("phone", userID);
				mapModel.put("token", token);
				log.info(mobile + " register success,userID is " + userID);
				Map<String, String> maps = new HashMap();
				maps.put(CookieUtil.USER_ID, userID + "");
				maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
				cookieUtil.setIdentity(request, response, maps, userID);
				mapModel.put("uid", userID);
				mapModel.addAttribute("code", 0);
			} else {
				log.error("wrong verifycode");
				mapModel.addAttribute("code", -2005);
				return "/common/success";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			mapModel.addAttribute("code", -1);
		}
		return "/muscle-main-service/user/json/register";
	}

	/* 验证码校验 */
	private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify)
			throws ServiceException, ServiceDaoException {
		log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
		// 是否有发送验证码
		Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
		log.info("sid is " + sid);

		if (sid == null) {
			return false;
		}
		// 获取验证码信息
		Sms sms = smsService.getObjectById(sid);
		log.info("sms is " + sms);
		// 获取验证码
		String message = sms.getMessage();
		log.info("message is " + message);

		// 发送是否超时
		Long delay = System.currentTimeMillis() - sms.getSendAt();

		if (delay > 600000) {
			log.info("require verify too long");
			return false;
		}

		if (message.equals(verify)) {
			return true;
		} else {
			return false;
		}

	}

	private boolean verifyModel() {
		return "test".equals(this.accountConfig.get("testModel"));
	}

	/* 忘记密码  */
	@RequestMapping(value = "/a/doctor/password/forget", method = RequestMethod.PUT)
	public String rewritepwd(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String verify, String newpwd) throws Exception {
		try {
			// 是否已注册
			Long uid = userService.getUserIdByMobile(mobile);

			// 用户不存在
			if (uid == null) {
				log.info(mobile + " not exist ");
				model.addAttribute("code", -2000);

				return "/common/success";

			} else {
				log.info(mobile + " exist and uid is " + uid);
			}

			boolean verifyResult = false;

			String type = "password";

			// 测试模式
			if (verifyModel()) {
				if ("555555".equals(verify)) {
					log.info("test ,so not verify mobile ");
					verifyResult = true;
				} else {
					verifyResult = verifyMobileCode(model, mobile, type, verify);
				}
			} else {
				verifyResult = verifyMobileCode(model, mobile, type, verify);
			}

			if (verifyResult) {
				User user = userService.getObjectById(uid);

				String encodePass = PasswordUtils.encode(newpwd);
				user.setPwd(encodePass);
				boolean result = userService.update(user);

				log.info(mobile + " change password," + newpwd + "result is " + result);
				log.error("rewrite password success! ");

				model.addAttribute("code", 0);
			} else {
				log.error("rewritepwd verifycode");
				model.addAttribute("code", -2005);

				return "/common/success";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}

	//验证码发送
	@RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
	public String sendVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String type) throws ServiceException, ServiceDaoException {
		log.info(mobile + " want send sms of type " + type);

		if (StringUtils.isBlank(mobile)) {
			log.info(mobile + " want send sms of type " + type + " null mobile ");
			model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
			return "/common/success";
		}

		if (StringUtils.isBlank(type)) {
			type = "password";
		}

		if ("register".equals(type)) {
			Long uid = this.userService.getUserIdByMobile(mobile);
			if (uid != null) {

				log.info(type + " is already exist  " + mobile);

				model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
				return "/common/success";
			}

		} else {
			Long uid = this.userService.getUserIdByMobile(mobile);
			if (uid == null) {

				log.info(type + " is not already exist  " + mobile);

				model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
				return "/common/success";
			}
		}

		int code = InterfaceCodeConstant.System_Success;

		try {
			log.info("sms is start");
			String result = this.smsService.sendMsg(mobile, type);

			switch (result) {
			case SmsService.ErrorCode_SMS_InvalidType:
				code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
				break;
			case SmsService.ErrorCode_SMS_smsMoreThan5:
				code = InterfaceCodeConstant.VerifyCode_MoreThan5;
				break;
			default:

			}

			model.addAttribute("code", code);

		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(mobile + " send message error of type " + type);
			model.addAttribute("code", InterfaceCodeConstant.System_Exception);

		}
		return "/common/success";

	}

	// 语音验证码
	@RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
	public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
			String type) throws ServiceException, ServiceDaoException {
		log.info(mobile + " want send voice of type " + type);

		if (StringUtils.isBlank(mobile)) {
			log.info(mobile + " want send sms of type " + type + " null mobile ");
			model.addAttribute("code", -2001);
			return "/common/success";
		}
		if (StringUtils.isBlank(type)) {
			type = "password";
		}

		if ("register".equals(type)) {
			Long uid = this.userService.getUserIdByMobile(mobile);
			if (uid != null) {
				log.info(type + " is already exist  " + mobile);
				model.addAttribute("code", -2007);
				return "/common/success";
			}
		} else {
			Long uid = this.userService.getUserIdByMobile(mobile);
			if (uid == null) {
				log.info(type + " is not already exist  " + mobile);
				model.addAttribute("code", -2000);
				return "/common/success";
			}
		}

		String realMobile = mobile;
		log.info("final mobile is : " + realMobile);

		int code = 0;

		try {
			String result = this.smsService.sendVoice(realMobile, type);
			switch (result) {
			case SmsService.ErrorCode_SMS_InvalidType:
				code = -2003;
				break;
			case SmsService.ErrorCode_SMS_smsMoreThan5:
				code = -2008;
				break;
			case SmsService.ErrorCode_sendError:
				code = -2015;
				break;
			default:

			}

			model.addAttribute("code", code);
		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(mobile + " send voice error of type " + type);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

}
