package com.ptteng.muscle.main.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.ptteng.muscle.util.DynamicUtil;
import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.model.Template;
import com.ptteng.muscle.main.service.DoctorService;
import com.ptteng.muscle.main.service.TemplateService;
import com.qding.common.util.DataUtils;
import com.gemantic.common.util.StringUtil;

/**
 * Template crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TemplateController {
	private static final Log log = LogFactory.getLog(TemplateController.class);

	@Autowired
	private TemplateService templateService;
	@Autowired
	private DoctorService doctorService;

	/* 方案模板列表 */
	@RequestMapping(value = "/a/u/search/template", method = RequestMethod.GET)
	public String getTemplateIdsByDidOrderByTemplateAtJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size, Long did, String name, Long createFrom, Long createTo,
			Long countFrom, Long countTo) throws Exception {

		log.info("========search template List ==========");
		log.info("doctor id is " + did);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Integer total = 0;
		boolean next = false;
		log.info("pageList : page= " + start + " , size=" + size);

		try {
			List<Template> templateList = new ArrayList<>();
			Map<String, Object> params = DynamicUtil.getTemplateQueryListParam(did, name, createFrom, createTo, countTo,
					countFrom, false);
			log.info("template dynamic sql params is " + params);

			List<Long> ids = templateService.getIdsByDynamicCondition(Template.class, params, start, size);
			log.info("template dynamic sql query ids is " + ids);

			if (DataUtils.isNotNullOrEmpty(ids)) {
				templateList = templateService.getObjectsByIds(ids);
				if (templateList.size() >= size) {
					templateList = templateList.subList(0, size);
					next = true;
				}
			} else {
				log.info("template ids is " + ids + "null");
			}

			Map<String, Object> paramsCount = DynamicUtil.getTemplateQueryListParam(did, name, createFrom, createTo,
					countTo, countFrom, true);
			List<Long> totalList = templateService.getIdsByDynamicCondition(Template.class, paramsCount, 0,
					Integer.MAX_VALUE);
			
			if (DataUtils.isNotNullOrEmpty(totalList)) {
				total = totalList.get(0).intValue();
				log.info("template total is " + total);
			}
			
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("next", next);
			model.addAttribute("total", total);
			model.addAttribute("templateList", templateList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get template list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}
		return "/muscle-main-service/template/json/templateListJson";
	}

	
	/* 模板详情 */
	@RequestMapping(value = "/a/template/{id}", method = RequestMethod.GET)
	public String getTemplateJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Template template = templateService.getObjectById(id);
			log.info("get template data is " + template);

			model.addAttribute("code", 0);

			model.addAttribute("template", template);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get template error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/template/json/templateDetailJson";
	}

	/* 编辑模板信息 */
	@RequestMapping(value = "/a/u/template", method = RequestMethod.PUT)
	public String updateTemplateJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			Long did, String name, String treatment, String duration, String time, String strength, String probe)
					throws Exception {

		log.info("update template : id " + id + " did " + did + " name " + name + " treatment " + treatment + "duration"
				+ duration + " time " + time + " strength " + strength + " probe " + probe);
		
		if (DataUtils.isNullOrEmpty(id)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		
		if (DataUtils.isNullOrEmpty(did)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		
		try {
			Template template = templateService.getObjectById(id);
			template.setDid(did);
			template.setName(name);
			template.setTreatment(treatment);
			template.setDuration(duration);
			template.setTime(time);
			template.setStrength(strength);
			template.setProbe(probe);

			boolean templateUpdate = templateService.update(template);
			if (templateUpdate){
				log.info("id is " + id + "template update is success!");
			}else{
				log.info("id is " + id + "template update is failure!");
			}
			model.addAttribute("code", 0);
			model.addAttribute("message", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update template error ");
			model.addAttribute("code", -6002);
		}
		return "/common/success";
	}

	/* 保存方案模板 */
	@RequestMapping(value = "/a/u/template", method = RequestMethod.POST)
	public String addTemplateJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long did,
			String name, String treatment, String duration, String time, String strength, String probe)
					throws Exception {

		log.info("insert template : did " + did + " name " + name + " treatment " + treatment + "duration" + duration
				+ " time " + time + " strength " + strength + " probe " + probe);

		if (DataUtils.isNullOrEmpty(did)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		try {
			Doctor doctor = doctorService.getObjectById(did);
			Template template = new Template();
			template.setDid(did);
			template.setName(name);
			template.setTreatment(treatment);
			template.setDuration(duration);
			template.setTime(time);
			template.setStrength(strength);
			template.setProbe(probe);
			template.setTemplateAt(System.currentTimeMillis());
			template.setCount(0L);

			Long id = templateService.insert(template);
			
			model.addAttribute("id", id);
			model.addAttribute("doctor", doctor);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add template error ");
			model.addAttribute("code", -6002);
		}
		return "/muscle-main-service/template/json/statusJson";
	}

	/* 批量删除模板 */
	@RequestMapping(value = "/a/u/template", method = RequestMethod.DELETE)
	public String getMultiTemplateJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids, Long pid, String token) throws Exception {

		log.info("delete template ids is =========" + ids);

		List<Long> idList = new ArrayList();
		if (ids == null) {
			log.info("ids is null");
		} else {
			idList = Arrays.asList(ids);
		}
		try {

			Template template = new Template();
			templateService.deleteList(template.getClass(), idList);
			List<Template> templateList = templateService.getObjectsByIds(idList);
			log.info("get  template data is " + templateList);

			model.addAttribute("code", 0);
			model.addAttribute("message", 0);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get template error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common/success";
	}

}
