package com.ptteng.muscle.main.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.model.ProgramRelation;
import com.ptteng.muscle.main.model.Template;
import com.ptteng.muscle.main.service.ProgramRelationService;
import com.ptteng.muscle.main.service.TemplateService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * ProgramRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProgramRelationController {
	private static final Log log = LogFactory.getLog(ProgramRelationController.class);

	@Autowired
	private ProgramRelationService programRelationService;
	
	@Autowired
	private CookieUtil cookieUtil;
	
	@Autowired
	private TemplateService templateService;


	/* 制定方案*/
	@RequestMapping(value = "/a/u/program", method = RequestMethod.POST)
	public String updateProgramRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long pid, Long did, Long tid,String name, String treatment, String duration, String time, String strength,
			String probe, String price, Integer status,Long sendAt, String conclusion) throws Exception {

		try {

			ProgramRelation programRelation = new ProgramRelation();
			Template template = templateService.getObjectById(tid);
			programRelation.setDid(did);
			programRelation.setPid(pid);
			programRelation.setTid(tid);
			programRelation.setName(name);
			programRelation.setTreatment(treatment);
			programRelation.setDuration(duration);
			programRelation.setTime(time);
			programRelation.setStrength(strength);
			programRelation.setProbe(probe);
			programRelation.setStatus(status);
			programRelation.setPrice(price);
			programRelation.setConclusion(conclusion);
			programRelation.setSendAt(System.currentTimeMillis());
			
			if (DataUtils.isNullOrEmpty(template)){
				log.info("template is null or empty");
			}else{
				template.setCount(template.getCount() + 1);
				templateService.update(template);
				log.info("template=======" + template);
			}
			
			Long id = programRelationService.insert(programRelation);
			
			model.addAttribute("code", 0);
			model.addAttribute("message", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add ProgramRelation error ");
			model.addAttribute("code", -6003);
		}
		return "/common/insert";
	} 
	
	/* 制定方案
	@RequestMapping(value = "/a/u/programtest", method = RequestMethod.POST)
	public String test(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			ProgramRelation programRelation ) throws Exception {

		try {

			Template template = templateService.getObjectById(programRelation.getTid());
			programRelation.setSendAt(System.currentTimeMillis());
			
			if (DataUtils.isNullOrEmpty(template)){
				log.info("template is null or empty");
			}else{
				template.setCount(template.getCount() + 1);
				templateService.update(template);
				log.info("template=======" + template);
			}
			
			Long id = programRelationService.insert(programRelation);
			
			model.addAttribute("code", 0);
			model.addAttribute("id", id);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add ProgramRelation error ");
			model.addAttribute("code", -6003);
		}
		return "/common/insert";
	}    
	*/
}

