package com.ptteng.muscle.main.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.model.ProgramRelation;
import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.main.service.DoctorService;
import com.ptteng.muscle.main.service.ProgramRelationService;
import com.ptteng.muscle.main.service.UserService;
import com.ptteng.muscle.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.sun.java.browser.net.ProxyService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.util.StringUtil;
import com.ptteng.muscle.main.model.Patient;
import com.ptteng.muscle.main.service.PatientService;

/**
 * Patient crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PatientController {
	private static final Log log = LogFactory.getLog(PatientController.class);

	@Autowired
	private PatientService patientService;
	@Autowired
	private UserService userService;
	@Autowired
	private DoctorService doctorService;
	@Autowired
	private ProgramRelationService programRelationService;

	/**
	 * 患者详情
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/patient/{id}", method = RequestMethod.GET)
	public String getPatientJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get patient id is  " + id);
		try {
			Patient patient = patientService.getObjectById(id);

			if (DataUtils.isNullOrEmpty(patient)) {
				log.info("patient is null");
				model.addAttribute("code", -2000);
				return "/common/success";
			}else{
				log.info("patient id : " + id + " exist !");
			}
			User user = userService.getObjectById(id);
			
			if (DataUtils.isNullOrEmpty(user)) {
				log.info("user is null");
				model.addAttribute("code", -2000);
				return "/common/success";
			}else{
				log.info("user id : " + id + " exist !");
			}

			model.addAttribute("code", 0);
			model.addAttribute("user", user);
			model.addAttribute("patient", patient);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get patient error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/patient/json/patientDetailJson";
	}

	/**
	 * 我的方案
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@RequestMapping(value = "/a/u/program/list", method = RequestMethod.GET)
	public String getProgramRelation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, Long pid) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		boolean next = false;
		Integer total = 0;

		try {

			List<ProgramRelation> programRelationList = new ArrayList<>();
			List<Doctor> doctorList = new ArrayList<>();
			List<Long> ids = new ArrayList<>();
			List<Long> totalList = new ArrayList<>();
			Map<String, Object> params = DynamicUtil.getProgramRelationQueryListParam(pid, false);
			ids = programRelationService.getIdsByDynamicCondition(ProgramRelation.class, params, start, size);

			if (DataUtils.isNotNullOrEmpty(ids)) {
				programRelationList = programRelationService.getObjectsByIds(ids);
				if (programRelationList.size() >= size) {
					programRelationList = programRelationList.subList(0, size);
					next = true;
				}
			}

			Map<String, Object> countParams = DynamicUtil.getProgramRelationQueryListParam(pid, true);
			totalList = programRelationService.getIdsByDynamicCondition(ProgramRelation.class, countParams, 0,
					Integer.MAX_VALUE);

			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(totalList)) {
				total = totalList.get(0).intValue();
			}

			Set<Long> dids = new HashSet<>();
			for (ProgramRelation programRelation : programRelationList) {
				dids.add(programRelation.getDid());
			}

			log.info("dids is :" + dids);
			doctorList = doctorService.getObjectsByIds(new ArrayList<>(dids));

			log.info("doctorList:" + doctorList);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("next", next);
			model.addAttribute("total", total);
			model.addAttribute("programRelationList", programRelationList);
			model.addAttribute("doctorList", doctorList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get hospital list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/programRelation/json/programRelationList";
	}
}
