package com.ptteng.muscle.main.controller;

import com.ptteng.muscle.main.model.Hospital;
import com.ptteng.muscle.main.service.HospitalService;
import com.ptteng.muscle.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Hospital crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class HospitalController {
	private static final Log log = LogFactory.getLog(HospitalController.class);

	@Autowired
	private HospitalService hospitalService;

	// 合作医院管理
	@RequestMapping(value = "/a/u/search/hospital", method = RequestMethod.GET)
	public String getHospitalIdsByCidAndGradeOrderByTotalJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size, Long cid, Integer grade,
			String name, Integer totalFrom, Integer totalTo, Integer status, String province, String city)
					throws Exception {
		
		log.info("======== search hospital ==========");
		log.info("cid is " + cid);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		boolean next = false;
		Integer total = 0;

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Hospital> hospitalList = new ArrayList<>();
			List<Long> ids = new ArrayList<>();
			List<Long> totalList = new ArrayList<>();

			Map<String, Object> params = DynamicUtil.getHospitalQueryParam(grade, name, totalFrom, totalTo, status,
					province, city, cid, false);
			log.info("hospital dynamic sql query param is  " + params);

			ids = hospitalService.getIdsByDynamicCondition(Hospital.class, params, start, size);
			log.info("ids is :" + ids );
			
			if (DataUtils.isNotNullOrEmpty(ids)) {
				hospitalList = hospitalService.getObjectsByIds(ids);
				if (ids.size() >= size) {
					hospitalList = hospitalList.subList(0, size);
					next = true;
				}
			}

			Map<String, Object> paramsCount = DynamicUtil.getHospitalQueryParam(grade, name, totalFrom, totalTo, status,
					province, city, cid, true);

			log.info("========" + paramsCount);
			totalList = hospitalService.getIdsByDynamicCondition(Hospital.class, paramsCount, 0, Integer.MAX_VALUE);

			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(totalList)) {
				total = totalList.get(0).intValue();
			}

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("next", next);
			model.addAttribute("total", total);
			model.addAttribute("hospitalList", hospitalList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get hospital list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/hospital/json/hospitalListJson";
	}

}
