package com.ptteng.muscle.main.controller;

import com.ptteng.muscle.common.model.Feedback;
import com.ptteng.muscle.common.service.FeedbackService;
import com.ptteng.muscle.main.service.UserService;
import com.ptteng.muscle.main.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Feedback  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class FeedbackController {
	private static final Log log = LogFactory.getLog(FeedbackController.class);

	@Autowired
	private FeedbackService feedbackService;

	@Autowired
	private UserService userService;





	@RequestMapping(value = "/a/u/feedback", method = RequestMethod.POST)
	public String addFeedbackJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Feedback feedback) throws Exception {
		
		log.info("add feedback : feedback= " + feedback);
		User user=userService.getObjectById(feedback.getUid());
		log.info("user ===="+user);
		try {
			Long uid = feedback.getUid();
			feedback.setUid(uid);
			feedback.setCreateBy(uid);
			feedback.setUpdateBy(uid);
			feedback.setMobile(user.getMobile());
			feedback.setType(user.getType());
			feedback.setId(null);

			Long id = feedbackService.insert(feedback);
			log.info(" user "+uid+" commit one feedback id = "+id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add feedback error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}




}

