package com.ptteng.muscle.main.controller;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;


import com.aliyun.oss.common.utils.DateUtil;
import com.ptteng.muscle.main.model.Equipment;
import com.ptteng.muscle.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.model.EquipmentRelation;
import com.ptteng.muscle.main.service.EquipmentRelationService;

/**
 * EquipmentRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class EquipmentRelationController {
	private static final Log log = LogFactory.getLog(EquipmentRelationController.class);

	@Autowired
	private EquipmentRelationService equipmentRelationService;


	/**获取所有relation数据
	 */
	@RequestMapping(value = "/a/u/equipmentRelation", method = RequestMethod.GET)
	public String getequipmentRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer page,Integer size,Long uid,Long eid) throws Exception {

		if (page == null){

			page = 1;
		}
		if (size == null){

			size = 10;
		}

		int start = (page - 1)*10;
		Integer total = 0;
		boolean next = false;
		log.info("equipment data start = " + start + " page = " + page);

		try {
			List<EquipmentRelation> list = new ArrayList<>();
			List<Long> ids = new ArrayList<>();
			List<Long> totals = new ArrayList<>();

			Map<String,Object> params = DynamicUtil.getEquipmentlRelationQueryParam(uid,eid);
			if (DataUtils.isNotNullOrEmpty(params)){

				ids = equipmentRelationService.getIdsByDynamicCondition(EquipmentRelation.class,params,start,size);
			}
			log.info("equipmentRelation ids = " + ids);

			if (DataUtils.isNotNullOrEmpty(ids)){

				list = equipmentRelationService.getObjectsByIds(ids);
			}

			log.info("equipmentRelation  list ==" + list);

			if (list.size() > size){

				list = list.subList(0,size);
			}

			//获取数据总数
			totals = equipmentRelationService.getIdsByDynamicCondition(EquipmentRelation.class,params,0,Integer.MAX_VALUE);
			if (DataUtils.isNotNullOrEmpty(totals)){

				total = totals.size();
			}

			model.addAttribute("code",0);
			model.addAttribute("page",page);
			model.addAttribute("size",size);
			model.addAttribute("total",total);
			model.addAttribute("equipmentRelationList",list);
			log.info("equipmentRelationList == " + list);

		}catch (Exception e){

			log.error(e.getMessage());
			log.error("get equipmentRelationList error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/equipmentRelation/json/equipmentRelationListJson";
	}


	/**
	 * 添加数据
	 */
	@RequestMapping(value = "/a/u/equipmentRelation", method = RequestMethod.POST)
	public String addUidsByEidList1(HttpServletRequest request,
									HttpServletResponse response, ModelMap model,Long uid, Long eid) throws Exception {

		if (DataUtils.isNullOrEmpty(uid)){

			model.addAttribute("code",0);
			model.addAttribute("message",-5070);
			return "/common/success";
		}

		if (DataUtils.isNullOrEmpty(eid)){

			model.addAttribute("code",0);
			model.addAttribute("message",-5071);
			return "/common/success";
		}

		try{

			//先查询是否添加过该条数据 uid和eid是否有匹配数据
			Long tempId = equipmentRelationService.getEquipmentRelationByUidAndEid(uid,eid);
			log.info("tempid == " + tempId);
			if (DataUtils.isNotNullOrEmpty(tempId)) {

				log.info("object is exit");
				model.addAttribute("code", 0);
				model.addAttribute("message",-5072);
				return "/common/success";
			}

			//创建存储对象
			EquipmentRelation equipmentRelation = new EquipmentRelation();
			equipmentRelation.setUid(uid);
			equipmentRelation.setEid(eid);

			equipmentRelationService.insert(equipmentRelation);
			model.addAttribute("code","0");
			model.addAttribute("message","success");
			log.info("add equipmentRelation success .  uid = " + uid + "eid = " + eid);

		}catch (Exception e){

			log.info("添加关系数据失败");
			log.info(e.getMessage());
		}

		return "/common/success";
	}

	public EquipmentRelationController() {

	}

	//删除数据
	@RequestMapping(value="/a/u/equipmentRelation/{id}",method = RequestMethod.DELETE)
	public String deleteEquipmentWithId(HttpServletRequest request,
										HttpServletResponse response, ModelMap model, @PathVariable Long id){

	    log.info("delete equipment with id = " + id);
		if (DataUtils.isNullOrEmpty(id)){
			model.addAttribute("code",0);
			model.addAttribute("message",-5073);
			return "/common/success";
		}

		//先判断id存在不存在
        try {

		    EquipmentRelation equipmentRelation = equipmentRelationService.getObjectById(id);
		    if (DataUtils.isNullOrEmpty(equipmentRelation)){

		        model.addAttribute("code",0);
		        model.addAttribute("message",-5074);
		        return "/common/success";
            }

            equipmentRelationService.delete(id);

            model.addAttribute("code",0);
            model.addAttribute("message",0);
		    log.info("delete equipmentRelation success");

        }catch (Exception e){

		    log.info(e.getMessage());
        }

		return "/common/success";
	}

	//获取单个id详情数据
    @RequestMapping(value="/a/u/equipmentRelation/{id}",method = RequestMethod.GET)
    String getEquipmentErlationWithId(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, @PathVariable Long id){

        if (DataUtils.isNullOrEmpty(id)){

            model.addAttribute("code",0);
            model.addAttribute("message",-5073);
            return "/common/success";
        }

        try {

            EquipmentRelation equipmentRelation = equipmentRelationService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(equipmentRelation)){

                model.addAttribute("code",0);
                model.addAttribute("message",-5074);
                return "/common/success";
            }

            log.info("equipmentRelation uid = " + equipmentRelation.getUid() + " equipmentRelation.eid =  " + equipmentRelation.getEid());
            model.addAttribute("code",0);
            model.addAttribute("equipmentRelation",equipmentRelation);
        }catch (Exception e){

            log.info(e.getMessage());
        }

        return "/muscle-main-service/equipmentRelation/json/equipmentRelationDetailJson";
    }
}

