package com.ptteng.muscle.main.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.ptteng.muscle.util.DynamicUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.model.Equipment;
import com.ptteng.muscle.main.service.EquipmentService;
import com.gemantic.common.util.StringUtil.*;

/**
 * Equipment  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class EquipmentController {
	private static final Log log = LogFactory.getLog(EquipmentController.class);

	@Autowired
	private EquipmentService equipmentService;

	//添加设备接口
	@RequestMapping(value = "/a/u/equipment", method = RequestMethod.POST)
	public String addEquipmentJson(HttpServletRequest request,
								   HttpServletResponse response, ModelMap mapModel,  Long id,String model,String version,String os,String device_token) throws Exception {

		log.info("add equipment : id= " + id + " model = " + model + " version = " + version + " os = " + os + " device_token = " + device_token );

		if(com.gemantic.common.util.StringUtil.isEmpty(model)){
			mapModel.addAttribute("code",0);
			mapModel.addAttribute("message",-5050);
			return "/common/success";
		}

		if(com.gemantic.common.util.StringUtil.isEmpty(version)){
			mapModel.addAttribute("code",0);

			mapModel.addAttribute("message",-5051);
			return "/common/success";
		}

		if(com.gemantic.common.util.StringUtil.isEmpty(os)){
			mapModel.addAttribute("code",0);
			mapModel.addAttribute("message",-5052);
			return "/common/success";
		}
		if(com.gemantic.common.util.StringUtil.isEmpty(device_token)){
			mapModel.addAttribute("code",0);

			mapModel.addAttribute("message",-5053);
			return "/common/success";
		}

		try {

			//判断是否添加过该设备
			Long equmpentIdd = equipmentService.getEquipmentByDeviceToken(device_token);
			if (DataUtils.isNotNullOrEmpty(equmpentIdd)) {
				log.info("object is exit");
				mapModel.addAttribute("code", 0);
				mapModel.addAttribute("message", -5054);
				return "/common/success";
			}

			Equipment equipment = new Equipment();

			equipment.setModel(model);

			equipment.setVersion(version);

			equipment.setOs(os);

			equipment.setDeviceToken(device_token);
			equipmentService.insert(equipment);

			mapModel.addAttribute("code", 0);
			mapModel.addAttribute("message", 0);

		} catch (Throwable t) {

			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add equipment error ");
			mapModel.addAttribute("code", -6002);
		}

		return "/common/success";
	}

	//删除设备接口
	@RequestMapping(value = "/a/u/equipment/{id}", method = RequestMethod.DELETE)
	public String deleteEquipmentJson(HttpServletRequest request,
									  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		Equipment equement = equipmentService.getObjectById(id);
		if (DataUtils.isNullOrEmpty(equement)){

			model.addAttribute("code","-5056");
			return "/common/success";
		}

		log.info("delete equipment : id= " + id);
		try {
			equipmentService.delete(id);

			log.info("add equipment success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete equipment error,id is  " + id);
			model.addAttribute("code", -6004);
		}

		return "/common/success";
	}

	//获取所有设备列表
	@RequestMapping(value = "/a/u/equipment", method = RequestMethod.GET)
	public String getequipmentList(HttpServletRequest request,
								   HttpServletResponse response, ModelMap model,Integer page,Integer size,String smodel, String version, String os,
								   String device_token) throws Exception {

		if (page == null){

			page = 1;
		}

		if (size == null){

			size = 10;
		}
		int start = (page - 1) *10;
		Integer total = 0;
		boolean next  = false;

		log.info("equipentsPage = " + page + "size = " + size);

		try {
			List<Equipment> equipmentList = new ArrayList<>();
			List<Long> ids = new ArrayList<>();
			List<Long> totalList = new ArrayList<>();

			Map<String, Object> params = DynamicUtil.getEquipmentlQueryParam(smodel,version,os,device_token);
			log.info("equipment dynamic sql query param is  " + params);
			if (DataUtils.isNotNullOrEmpty(params)){

				ids = equipmentService.getIdsByDynamicCondition(Equipment.class,params,start,size);
			}
			log.info("equipment  ids is  " + ids);

			if (DataUtils.isNotNullOrEmpty(ids)){

				equipmentList = equipmentService.getObjectsByIds(ids);


				if (ids.size() >= size){

					equipmentList = equipmentList.subList(0,size);
					next = true;
				}
			}

			log.info("equipmentList  is  " + equipmentList);

			Map<String, Object> paramsCount = DynamicUtil.getEquipmentlQueryParam(smodel,version,os,device_token);
			if (DataUtils.isNotNullOrEmpty(paramsCount)){

				totalList = equipmentService.getIdsByDynamicCondition(Equipment.class,paramsCount,0,Integer.MAX_VALUE);
			}

			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(totalList)) {

				total = totalList.size();
			}

			model.addAttribute("code",0);
			model.addAttribute("page",page);
			model.addAttribute("size",size);
			model.addAttribute("next",next);
			model.addAttribute("total",total);
			model.addAttribute("equmentList",equipmentList);
			log.info("equipmentList  is  " + equipmentList);

		}catch (Throwable t) {

			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get equipment list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/equipment/json/equipmentListJson";
	}

	//获取单个设备信息
	@RequestMapping(value = "/a/u/equipment/{id}", method = RequestMethod.GET)
	public String getEquipment(HttpServletRequest request,
							   HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		boolean nonData = false;
		try{

			Equipment equipment = equipmentService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(equipment)){

				model.addAttribute("code","-5056");
				log.info("get equment info is ------------return");
				nonData = true;
			}else{

				model.addAttribute("equipment",equipment);
				log.info("get equment info is " + equipment);
				model.addAttribute("code",0);
			}
		}catch (Exception e){

			e.printStackTrace();
			log.error("get equment error");
			log.error(e.getMessage());
			model.addAttribute("code",-10000);
		}

		log.info("model = " + model);
		if (nonData){

			return "/muscle-main-service/equipment/json/equipmentNonoDataJson";
		}else {

			return "/muscle-main-service/equipment/json/equipmentDetailJson";
		}
	}

	//修改单个设备信息
	@RequestMapping(value = "/a/u/equipment/{id}",method = RequestMethod.PUT)
	public String updatEquement(HttpServletRequest request,
								HttpServletResponse response, ModelMap model,Long id,String os,String version,String modelName,String deviceToken) throws Exception{




		try {
			Equipment equipment = equipmentService.getObjectById(id);

			if (DataUtils.isNotNullOrEmpty(id)){
				equipment.setId(id);
			}

			if (DataUtils.isNotNullOrEmpty(os)){
				equipment.setOs(os);
			}

			if (DataUtils.isNotNullOrEmpty(version)){
				equipment.setVersion(version);
			}

			if (DataUtils.isNotNullOrEmpty(modelName)){
				equipment.setModel(modelName);
			}

			if (DataUtils.isNotNullOrEmpty(deviceToken)){
				equipment.setDeviceToken(deviceToken);
			}

			log.info("request paraments = id =  " + id + " model = " + modelName + " os = " + os + " version = " + version + " deviceToken =" + deviceToken);

			log.info("update equment = " + equipment);

			equipmentService.update(equipment);

			model.addAttribute("code",0);
			model.addAttribute("message","success");
			log.info("修改机器信息成功");

		}catch (Exception e){

			e.printStackTrace();
			log.info("修改机器信息失败");
			model.addAttribute("code",-10000);
			model.addAttribute("message",-10000);

		}

		return "/data/json";
	}


	public EquipmentController() {

	}
}

