package com.ptteng.muscle.main.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.print.Doc;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.StringUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.pwd.PasswordUtils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.muscle.main.model.Apply;
import com.ptteng.muscle.main.model.Comment;
import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.model.Hospital;
import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.main.service.ApplyService;
import com.ptteng.muscle.main.service.CommentService;
import com.ptteng.muscle.main.service.DoctorService;
import com.ptteng.muscle.main.service.HospitalService;
import com.ptteng.muscle.main.service.UserService;

/**
 * Doctor crud
 * 
 * @author weiqi
 * @Date 2017-7-22
 * 
 */
@Controller
public class DoctorController {
	private static final Log log = LogFactory.getLog(DoctorController.class);

	@Autowired
	private DoctorService doctorService;

	@Autowired
	private ImgStorageUtil imgStorageUtil;
	@Autowired
	private UserService userService;
	@Autowired
	private ApplyService applyService;
	@Autowired
	private HospitalService hospitalService;
	
	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;

	
	
	/* 医师认证 */
	@RequestMapping(value = "/a/u/certification", method = RequestMethod.POST)
	public String doctorCertification(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			Integer status, Long cid, Long hid, String position, String name, String idNo, String qualifications, String certificate,
			String certificateBack) {

		log.info("doctor : hid = [" + hid + "], position = [" + position + "], name = [" + name + "]," + "idNo = ["
				+ idNo + "], qualifications = [" + qualifications + "], certificate = [" + certificate
				+ "], certificateBack = [" + certificateBack + "], cid = [" + cid + "]");
		
		
		if (DataUtils.isNullOrEmpty(id)) {
			model.addAttribute("code", -5000);
			return "/common/success";
		}
		
		if (DataUtils.isNullOrEmpty(status)) {
			model.addAttribute("code", -5000);
			return "/common/success";
		}
		
		if (DataUtils.isNullOrEmpty(hid)) {
			model.addAttribute("code", -5000);
			return "/common/success";
		}

		if (StringUtil.isEmpty(position)) {
			model.addAttribute("code", -5001);
			return "/common/success";
		}

		if (StringUtil.isEmpty(name)) {
			model.addAttribute("code", -5002);
			return "/common/success";
		}
		if (StringUtil.isEmpty(idNo)) {
			model.addAttribute("code", -5003);
			return "/common/success";
		}
		if (StringUtil.isEmpty(qualifications)) {
			model.addAttribute("code", -5004);
			return "/common/success";
		}

		if (StringUtil.isEmpty(certificate)) {
			model.addAttribute("code", -5006);
			return "/common/success";
		}

		if (StringUtil.isEmpty(certificateBack)) {
			model.addAttribute("code", -5006);
			return "/common/success";
		}
		

		try {

			Doctor doctor = doctorService.getObjectById(id);
			User user = userService.getObjectById(id);
			
			doctor.setCid(cid);
			doctor.setStatus(status);
			doctor.setName(name);
			doctor.setHid(hid);
			doctor.setPosition(position);
			doctor.setIdNo(idNo);
			doctor.setQualifications(qualifications);
			doctor.setCertificate(certificate);
			doctor.setCertificateBack(certificateBack);
			doctor.setApply(System.currentTimeMillis());
			user.setName(name);
			
			boolean doctorUpdate = doctorService.update(doctor);
			if(doctorUpdate){
				log.info("id is " + id + " doctor update is success!" );
			} else {
				log.info("id is " + id + " doctor update is failure!" );
			}
			
			boolean userUpdate = userService.update(user);
			if(userUpdate){
				log.info("id is " + id + " user update is success!");
			} else {
				log.info("id is " + id + " user update is failure!");
			}
			model.addAttribute("doctor",doctor);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error("certification error");
			log.error(t.getMessage(), t);
			model.addAttribute("code", -1);
		}
		return "/common/certificationJson";
	}
	
	
	/* 医师认证图片上传 */
	@RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
	public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@RequestParam MultipartFile file, @PathVariable String module) throws Exception {
		log.info("hello upload " + module);
		if (StringUtils.isBlank(module)) {
			module = "common";
		}
		int code = 0;
		log.info(file.getOriginalFilename());

		Long uid = cookieUtil.getID(request, response);
		try {
			String type = file.getContentType();
			long size = file.getSize();
			log.info("  size is =" + size / 1048576);
			String extend = FileUtil.getFileExtension(file.getOriginalFilename());

			String fileName = UUID.randomUUID().toString() + "." + extend;
			log.info("new name is " + fileName);
			String filePath = "/data/temp/" + fileName;

			File tempPic = new File(filePath);
			file.transferTo(tempPic);
			String url = this.imgStorageUtil.imgStorage(null, module + "/" + fileName, filePath);
			log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
					+ " access url is " + url);
			tempPic.delete();
			log.info(file.getOriginalFilename() + " delete success ");
			model.addAttribute("url", url);
			model.addAttribute("code", 0);
			return "/common/img";
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			return "/common/success";
		}

	}
	
	/* 修改医师资料  */
	@RequestMapping(value = "/a/u/doctor", method = RequestMethod.PUT)
	public String updateDoctorJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			String name, String position, String img, String qualifications, String introduction) throws Exception {

		log.info("get doctor id is " + id);

		if (null == id) {
			log.info("doctor id is null");
			model.addAttribute("code", -10008);
			return "/common/fail";
		}
		Doctor doctor = doctorService.getObjectById(id);
		User user = userService.getObjectById(id);
		try {
			// 医师的createBy,createAt维持原来不变
			doctor.setCreateBy(doctor.getCreateBy());
			doctor.setCreateAt(doctor.getCreateAt());
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("set createBy and creatAt error,id is  " + id);
			model.addAttribute("code", -6003);
		}
		try {
			user.setName(name);
			doctor.setName(name);
			doctor.setPosition(position);
			doctor.setImg(img);
			doctor.setQualifications(qualifications);
			doctor.setIntroduction(introduction);
			boolean userUpdate = userService.update(user);
			if(userUpdate){
				log.info("userUpdate id is " + id + "success!");
			}else{
				log.info("userUpdate id is " + id + "failure!");
			}
			boolean doctorUpdate = doctorService.update(doctor);
			
			log.info("update doctor = " + doctor);
			model.addAttribute("code", 0);
			model.addAttribute("doctor", doctor);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update doctor error,id is  " + doctor.getId());
			model.addAttribute("code", -6003);
		}

		return "/common/success";
	}

	
	/* 获取医师详情 */

    @RequestMapping(value = "/a/u/doctor/{id}", method = RequestMethod.GET)
    public String getDoctorJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("id is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            Doctor doctor = doctorService.getObjectById(id);
            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(doctor)) {
                log.info("doctor is exits");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            
            Hospital hospital = hospitalService.getObjectById(doctor.getHid());

            model.addAttribute("code", 0);
            model.addAttribute("doctor", doctor);
            model.addAttribute("hospital", hospital);
            model.addAttribute("user",user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get doctor error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/muscle-main-service/doctor/json/doctorDetailJson";
    }

	
		
	/*  获取认证医师 */
	@RequestMapping(value = "/a/u/doctor/certification", method = RequestMethod.GET)
	public String getDoctorCertification(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long id, Integer status) throws Exception {

		log.info("get data : id= " + id);
		
		if (DataUtils.isNotNullOrEmpty(id)){
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		
		if (status != Doctor.VERIFIED){
			model.addAttribute("code", -1000);
			return "/common/success";
		}

        try {
            Doctor doctor = doctorService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(doctor)) {
                log.info("doctor is exits");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            Hospital hospital = hospitalService.getObjectById(doctor.getHid());

            model.addAttribute("code", 0);
            model.addAttribute("doctor", doctor);
            model.addAttribute("hospital", hospital);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get doctor error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/muscle-main-service/doctor/json/doctorDetailJson";
    }

}
