package com.ptteng.muscle.main.controller;

import com.ptteng.common.muscle.model.Article;
import com.ptteng.common.muscle.service.ArticleService;
import com.ptteng.muscle.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Article crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog(ArticleController.class);
    private static final String ANDROID = "android";
    private static final String IOS = "ios";

    @Autowired
    private ArticleService articleService;



    /**
     * 单个查询展示内容
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id) throws Exception {

        log.info("get data : id= " + id);
        try {
            if (id == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(id);
                if (article == null) {
                    model.addAttribute("code", 2);
                    return "/common/success";
                } else {
                    log.info("get article data is " + article);
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/muscle-main-service/article/json/articleDetailJson";
    }



    /**
     * 条件查询内容
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param startAt
     * @param endAt
     * @param type
     * @param createByName
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/search", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,String author,
                                 Integer size, Long startAt, Long endAt, Integer type, String title, String createByName, String status)
            throws Exception {
        log.info("/web/a/article/list ,page is:" + page + ",size is" + size + ",startAt is" + startAt + ",endAt is"
                + endAt + ", type is " + "" + type + " , source is " + " createByName is " + createByName + " status is "
                + status+"author is "+author);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        try {

            Map<String, Object> param = DynamicUtil.getArticleListParam(startAt, endAt, type, createByName, title, status,author);
            log.info("        param is    " + param);
            log.info("pageList : page= " + start + " , size=" + size);
            ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
            count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("===============================================2" + ids + "=====" + total);

            if (ids != null && ids.size() > 0) {

                log.info("get article list ids is" + ids);
                List<Article> articleList = articleService.getObjectsByIds(ids);
                List<Long> managerIds = new ArrayList<>();
                for (Article article : articleList) {
                    managerIds.add(article.getCreateBy());
                }

                model.addAttribute("articleList", articleList);

            }
//            else {
//                model.addAttribute("code", 2);
//                return "/common/success";
//            }
            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {

                next = true;
            }
            model.addAttribute("next", next);
            log.info("next is : " + next);

            Integer totalPage = 1;
            if (total > 0) {

                totalPage = (total - 1) / size + 1;
                log.info("totalPage is : " + totalPage);
            }

            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get articleList error,qfrom is" + startAt + ",qto is" + endAt + ", type is " + "" + type
                    + " , source is " + ",createByName is " + createByName + ",status is " + status+",author is "+author);
            model.addAttribute("code", -1);
        }

        return "/muscle-main-service/article/json/articleMultiJson";
    }


}
