package com.ptteng.muscle.main.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.muscle.main.model.Apply;
import com.ptteng.muscle.main.model.Doctor;
import com.ptteng.muscle.main.model.Patient;
import com.ptteng.muscle.main.model.Template;
import com.ptteng.muscle.main.model.User;
import com.ptteng.muscle.main.service.ApplyService;
import com.ptteng.muscle.main.service.PatientService;
import com.ptteng.muscle.main.service.UserService;
import com.ptteng.muscle.util.DynamicUtil;
import com.qding.common.util.DataUtils;

/**
 * Apply crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ApplyController {
	private static final Log log = LogFactory.getLog(ApplyController.class);

	@Autowired
	private ApplyService applyService;

	@Autowired
	private PatientService patientService;
	
	@Autowired
	private UserService userService;

	
	
	/*患者申请列表*/
	@RequestMapping(value = "/a/u/apply/list", method = RequestMethod.GET)
	public String getapplyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long did, String name, String mobile, Integer page, Integer size, Integer status) throws Exception {
		
		log.info("=======search patient and doctor apply List=======");
        log.info("patient apply search pid is :" + did);
        
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Integer total = 0;
		boolean next = false;
		log.info("pageList : page= " + start + " , size=" + size);
		
		if (DataUtils.isNullOrEmpty(did)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

		try {
			/*获取绑定医师的患者列表*/
			 log.info("=======get patient bind doctor=======");
			
			List<User> userList = new ArrayList<>();
			List<Apply> applyList = new ArrayList<>();
            List<Patient> patientList = new ArrayList<>();

			/*获取申请id*/
			Map<String, Object> params = DynamicUtil.getApplyListParam(did, name, status, false);
			log.info("apply dynamic sql params is " + params);

			List<Long> ids = applyService.getIdsByDynamicCondition(Apply.class, params, start, size);
			log.info("apply dynamic sql query aids is " + ids);
			
			/*统计患者总数*/
			Map<String, Object> paramsCount = DynamicUtil.getApplyListParam(did, name,status, true);
			log.info("apply dynamic sql paramsCount is " + paramsCount);
			
			/*Map转成List*/
			List<Long> totalList = applyService.getIdsByDynamicCondition(Apply.class, paramsCount, 0,
					Integer.MAX_VALUE);
			if (DataUtils.isNotNullOrEmpty(totalList)) {
				total = totalList.get(0).intValue();
				log.info("apply total is " + total);
			}else{
				log.info("total number is null");
			}
			
			/*通过申请id，遍历患者id*/
			log.info("=======get patient data for apply ids=======");
			applyList = applyService.getObjectsByIds(ids);
			Set<Long> pids = new HashSet<>();
            for (Apply apply : applyList) {
                pids.add(apply.getPid());
            }
            log.info("patient ids is " + pids);
            
            if (CollectionUtils.isNotEmpty(pids)) {
                patientList = patientService.getObjectsByIds(new ArrayList<Long>(pids));
            }else{
            	log.info("patientlist ids:" + ids +"get patient data is null");
            }
            
            if (CollectionUtils.isNotEmpty(pids)){
            	userList = userService.getObjectsByIds(new ArrayList<Long>(pids));
            }else{
            	log.info("userlist ids:" + ids +"get user data is null");
            }

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("patientList", patientList);
			model.addAttribute("applyList", applyList);
			model.addAttribute("userList", userList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get apply list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/apply/json/applyListJson";
	}
	
	
	/** 患者通讯录   
	 *  备注：查patient表的did来判断是否绑定了医师
	 *  患者端有解绑医师的操作
	 */
	@RequestMapping(value = "/a/u/newsletter", method = RequestMethod.GET)
	public String getNewsletterList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long did, String name, String mobile, Integer page, Integer size) throws Exception {
		
		log.info("=======search patient and doctor newsletter List=======");
		log.info("doctor id is :" + did);
		
		if (DataUtils.isNullOrEmpty(did)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		
		int limit = 10;
		Integer total = 0;
		boolean next = false;
		log.info("pageList : page= " + start + " , size=" + size);

		try {
			
			List<User> userList = new ArrayList<>();
            List<Patient> patientList = new ArrayList<>();

			/*获取患者id*/
			Map<String, Object> params = DynamicUtil.getNewsletterListParam(did, name, false);
			log.info("patient dynamic sql params is " + params);

			List<Long> ids = applyService.getIdsByDynamicCondition(Apply.class, params, start, size);
			log.info("patient dynamic sql query ids is " + ids);
			
			/*统计总数*/
			Map<String, Object> paramsCount = DynamicUtil.getNewsletterListParam(did,name, true);
			log.info("patient dynamic sql paramsCount is " + paramsCount);
			List<Long> totalList = applyService.getIdsByDynamicCondition(Apply.class, paramsCount, 0,
					Integer.MAX_VALUE);
			
			if (DataUtils.isNotNullOrEmpty(totalList)) {
				total = totalList.get(0).intValue();
			}else{
				log.info("============total is null===========");
			}
			log.info("template total is " + total);
			
            if (DataUtils.isNotNullOrEmpty(ids)) {
                patientList = patientService.getObjectsByIds(new ArrayList<Long>(ids));
                userList = userService.getObjectsByIds(new ArrayList<Long>(ids));
            }else{
            	log.info("patientService and userService ids is" + ids + "data is null");
            }
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("patientList", patientList);
			model.addAttribute("userList", userList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get apply list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -100000);
		}

		return "/muscle-main-service/apply/json/newsletterJson";
	}
	

	
	/*修改申请状态*/
	@RequestMapping(value = "/a/u/apply/status", method = RequestMethod.PUT)
	public String updateApplyStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			Integer status) throws Exception {
		
		log.info("Apply id is " + id);
		log.info("Doctor Status is " + status);
		

		if (DataUtils.isNullOrEmpty(id)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		if (DataUtils.isNullOrEmpty(status)) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}
		
		/*判断医师是否已认证，撤销认证状态*/
		if (status != Doctor.VERIFIED){
			model.addAttribute("code", -25001);
			return "/common/success";
		}

		try {
			Apply apply = applyService.getObjectById(id);
			log.info("apply data is " + apply);
			apply.setStatus(status);

			Long pid = apply.getPid();
			Long did = apply.getDid();

			Patient patient = patientService.getObjectById(pid);
			log.info("patient Object is " + patient);
			
			if (DataUtils.isNullOrEmpty(patient)) {
				log.info("patient is not exits");
				model.addAttribute("code", -1000);
				return "/common/success";
			}
			
			patient.setDid(did);
			boolean patientUpdate = patientService.update(patient);
			if (patientUpdate) {
				log.info("id is " + id +" patient update is success!");
			} else {
				log.info("id is " + id +" patient update is failure!");
			}
			boolean applyUpdate = applyService.update(apply);
			if (applyUpdate) {
				log.info("id is " + id + " apply update is success!");
			} else {
				log.info("id is " + id + " apply update is failure!");
			}
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update apply error");
			model.addAttribute("code", -6003);
		}
		return "/common/success";
	}

}
