package com.ptteng.muscle.constant;

/**
 * 跟exception-message-play.properties 一一对应
 *
 * @author Administrator
 */
public class InterfaceCodeConstant {

    /**
     * 系统错误
     */
    public static final int System_Exception = -1;


    /**
     * 成功
     */
    public static final int System_Success = 0;


    /**
     * 用户不存在
     */
    public static final int User_NotExist = -2000;
    /**
     * 手机号不能为空
     */
    public static final int Mobile_Null = -2001;

    /**
     * 该手机已注册
     */
    public static final int Mobile_AlreadyExist = -2007;
    /**
     * 验证码超时
     */
    public static final int VerifyCode_TimeOut = -2004;
    /**
     * 验证码错误
     */
    public static final int VerifyCode_Error = -2005;
    /**
     * 密码错误
     */
    public static final int Password_Error = -2006;


    /**
     * 不支持的验证码类型
     */
    public static final int VerifyCode_Type_NotSupport = -2003;


    /**
     * 当日发送验证码超过5次
     */
    public static final int VerifyCode_MoreThan5 = -2008;


    /**
     * 发送失败
     */
    public static final int VerifyCode_sendError = -2009;


    /**
     * 关注的用户不存在
     */
    public static final int Fans_FollowID_NotExist = -3000;

    /**
     * 不能关注自己
     */

    public static final int Fans_FollowID_NotSelf = -3001;


    /***
     * 关注的用户已存在
     */
    public static final int Fans_FollowID_AlreadyExist = -3002;


    /**
     * 上次认证还未结束
     */
    public static final int LastVerify_NotFinish = -4000;


}
