-- ----------------------------
-- Table structure for `feedback`
-- ----------------------------
-- DROP TABLE IF EXISTS `feedback`;
CREATE TABLE `feedback` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '������ID',  
    `uid` bigint NOT NULL   COMMENT '用户ID',
    `opinion` text NOT NULL   COMMENT '意见',
    `create_at` bigint NOT NULL   COMMENT '����ʱ��',  
    `update_at` bigint NOT NULL   COMMENT '����ʱ��',  
    `create_by` bigint NOT NULL   COMMENT '������',  
    `update_by` bigint    COMMENT '������',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `message`
-- ----------------------------
-- DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '������ID',  
    `title` varchcar(50) NOT NULL   COMMENT '标题',
    `person_type` int(1)    COMMENT '发送人群',
    `type` int(1)    COMMENT '时间类型(立即推送、定时推送)',
    `content` text NOT NULL   COMMENT '正文',
    `url` varchcar(500)    COMMENT 'img(跳转图片，如果为空，则不跳转)',
    `push_at` bigint    COMMENT '推送时间',
    `status` int(1) NOT NULL   COMMENT 'status',  
    `create_at` bigint NOT NULL   COMMENT '����ʱ��',  
    `update_at` bigint NOT NULL   COMMENT '����ʱ��',  
    `create_by` bigint NOT NULL   COMMENT '������',  
    `update_by` bigint    COMMENT '������',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `sms`
-- ----------------------------
-- DROP TABLE IF EXISTS `sms`;
CREATE TABLE `sms` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '������ID',  
    `message` varchar(500) NOT NULL   COMMENT '发送内容',
    `type` varchar(50) NOT NULL   COMMENT '类型',
    `mobile` varchar(30) NOT NULL   COMMENT '手机号',
    `count` int(20) NOT NULL   COMMENT '次数',
    `send_at` bigint    COMMENT '发送时间',
    `type_send_at` bigint    COMMENT '发送时间',
    `create_at` bigint NOT NULL   COMMENT '����ʱ��',  
    `update_at` bigint NOT NULL   COMMENT '����ʱ��',  
    `create_by` bigint NOT NULL   COMMENT '������',  
    `update_by` bigint    COMMENT '������',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `userMessage`
-- ----------------------------
-- DROP TABLE IF EXISTS `userMessage`;
CREATE TABLE `userMessage` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '������ID',  
    `uid` bigint NOT NULL   COMMENT '用户ID',
    `title` varchar(200) NOT NULL   COMMENT 'title',  
    `summary` varchar(200)    COMMENT '内容',
    `invest_id` bigint    COMMENT '投资ID',
    `img` varchar(500)    COMMENT '图片',
    `status` int(1) NOT NULL   COMMENT '状态:已读未读 0--未读',
    `message_id` bigint    COMMENT '消息ID',
    `create_at` bigint    COMMENT '����ʱ��',  
    `update_at` bigint    COMMENT '����ʱ��',  
    `create_by` bigint    COMMENT '������',  
    `update_by` bigint    COMMENT '������',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `version`
-- ----------------------------
-- DROP TABLE IF EXISTS `version`;
CREATE TABLE `version` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'ID',
    `app` varchar(200) NOT NULL   COMMENT '患者版or医师版',
    `platform` varchar(200) NOT NULL   COMMENT '平台：ios/安卓',
    `version_name` varchar(200)    COMMENT '版本名称',
    `version_id` bigint    COMMENT '版本号',
    `url` varchar(500)    COMMENT '安装包URL',
    `info`  text       COMMENT '版本信息',
    `force_update` int(1)  NOT NULL  COMMENT '是否强制更新，0不强制 1强制, 默认0',
    `create_at` bigint    COMMENT '',
    `update_at` bigint    COMMENT '',
    `create_by` bigint    COMMENT '',
    `update_by` bigint    COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




