/**
 * 
 */
package com.ptteng.sca.muscle.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.muscle.common.model.Message;
import com.ptteng.muscle.common.model.UserMessage;
import com.ptteng.muscle.common.service.MessageService;

import java.util.List;
import java.util.Map;

public class MessageSCAClient implements MessageService {

    private MessageService messageService;

	public MessageService getMessageService() {
		return messageService;
	}
	
	
	public void setMessageService(MessageService messageService) {
		this.messageService =messageService;
	}
	
	
			   
		@Override
		public Long insert(Message message)throws ServiceException, ServiceDaoException{
		
		return messageService.insert(message);
		          
		
		}	
		  
    	   
		@Override
		public List<Message> insertList(List<Message> messageList)throws ServiceException, ServiceDaoException{
		
		return messageService.insertList(messageList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return messageService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Message message)throws ServiceException, ServiceDaoException{
		
		return messageService.update(message);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Message> messageList)throws ServiceException, ServiceDaoException{
		
		return messageService.updateList(messageList);
		          
		
		}	
		  
    	   
		@Override
		public Message getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return messageService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Message> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return messageService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getMessageIdsByTypeAndStatus(Integer type,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return messageService.getMessageIdsByTypeAndStatus(type,status,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countMessageIdsByTypeAndStatus(Integer type,Integer status)throws ServiceException, ServiceDaoException{
		
		return messageService.countMessageIdsByTypeAndStatus(type,status);
	
	
	}
	
		
	
		@Override
	public List<Long> getMessageIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return messageService.getMessageIds(start, limit);
	}

	@Override
	public Integer countMessageIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return messageService.countMessageIds();
	}

	@Override
	public void sendNotice(Message message) throws ServiceException, ServiceDaoException {
		messageService.sendNotice(message);
	}

	@Override
	public void sendNoticeUnicast(UserMessage message, String deviceToken, String os) throws ServiceException, ServiceDaoException {
		messageService.sendNoticeUnicast(message,deviceToken,os);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return messageService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return messageService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   messageService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.messageService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

