-- ----------------------------
-- Table structure for `sensitivity_report`
-- ----------------------------
-- DROP TABLE IF EXISTS `sensitivity_report`;
CREATE TABLE `sensitivity_report` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `sensitivity_cold_base` int NOT NULL   COMMENT '基准线冷觉温度',  
    `sensitivity_pain_base` int NOT NULL   COMMENT '基准线冷痛温度',  
    `sensitivity_hot_base` int NOT NULL   COMMENT '基准线热觉温度',  
    `sensitivity_hot_pain_base` int NOT NULL   COMMENT '基准线热痛温度',  
    `sensitivity_cold_upper_limit` double NOT NULL   COMMENT '上限冷觉温度',  
    `sensitivity_pain_upper_limit` double NOT NULL   COMMENT '上限冷痛温度',  
    `sensitivity_hot_upper_limit` double NOT NULL   COMMENT '上限热觉温度',  
    `sensitivity_hot_pain_upper_limit` double NOT NULL   COMMENT '上限热痛温度',  
    `sensitivity_cold_lower_limit` double NOT NULL   COMMENT '下限冷觉温度',  
    `sensitivity_pain_lower_limit` double NOT NULL   COMMENT '下限冷痛温度',  
    `sensitivity_hot_lower_limit` double NOT NULL   COMMENT '下限热觉温度',  
    `sensitivity_hot_pain_lower_limit` double NOT NULL   COMMENT '下限热痛温度',  
    `sensitivity_cold_avg` double NOT NULL   COMMENT '冷觉温度平均值',  
    `sensitivity_pain_avg` double NOT NULL   COMMENT '冷痛温度平均值',  
    `sensitivity_hot_avg` double NOT NULL   COMMENT '热觉温度平均值',  
    `sensitivity_hot_pain_avg` double NOT NULL   COMMENT '热痛温度平均值',  
    `sensitivity_cold_sta_dff` double NOT NULL   COMMENT '冷觉温度标准差',  
    `sensitivity_pain_sta_dff` double NOT NULL   COMMENT '冷痛温度标准差',  
    `sensitivity_hot_sta_dff` double NOT NULL   COMMENT '热觉温度标准差',  
    `sensitivity_hot_pain_sta_dff` double NOT NULL   COMMENT '热痛温度标准差',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint    COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





