/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.admin.model.Role;
import com.ptteng.learn.admin.service.RoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RoleServiceImpl
extends BaseDaoServiceImpl
implements RoleService {
    private static final Log log = LogFactory.getLog(RoleServiceImpl.class);
    @Autowired
    private Dao dao;

    public Long insert(Role role) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert data : " + role));
        }
        if (role == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        role.setCreateAt(Long.valueOf(currentTimeMillis));
        role.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)role);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + role));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert data success : " + result));
        }
        return result;
    }

    public List<Role> insertList(List<Role> roleList) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert lists : " + (roleList == null ? "null" : Integer.valueOf(roleList.size()))));
        }
        List resultList = null;
        if (CollectionUtils.isEmpty(roleList)) {
            return new ArrayList<Role>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Role role : roleList) {
            role.setCreateAt(Long.valueOf(currentTimeMillis));
            role.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(roleList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + roleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        }
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" delete data : " + id));
        }
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Role.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" delete data success : " + id));
        }
        return result;
    }

    public boolean update(Role role) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (role == null ? "null" : role.getId())));
        boolean result = false;
        if (role == null) {
            return true;
        }
        role.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)role);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + role));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + role));
        }
        return result;
    }

    public boolean updateList(List<Role> roleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (roleList == null ? "null" : Integer.valueOf(roleList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(roleList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Role role : roleList) {
            role.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(roleList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + roleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update lists success : " + roleList.size()));
        }
        return result;
    }

    public Role getObjectById(Long id) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get data : " + id));
        }
        Role role = null;
        if (id == null) {
            return role;
        }
        try {
            role = (Role)this.dao.get(Role.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get data success : " + id));
        }
        return role;
    }

    public List<Role> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        }
        List role = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Role>();
        }
        try {
            role = this.dao.getList(Role.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get data success : " + (role == null ? "null" : Integer.valueOf(role.size()))));
        }
        return role;
    }

    public List<Long> getRoleIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by name,start,limit  ================== " + name + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRoleIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getRoleIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRoleIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRoleIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRoleIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRoleIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

