/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.admin.service.ManagerService;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagerServiceImpl
extends BaseDaoServiceImpl
implements ManagerService {
    private static final Log log = LogFactory.getLog(ManagerServiceImpl.class);
    @Autowired
    private Dao dao;

    public Long insert(Manager manager) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert data : " + manager));
        }
        if (manager == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        manager.setCreateAt(Long.valueOf(currentTimeMillis));
        manager.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            log.info((Object)("============" + this.dao));
            result = (Long)this.dao.save((Object)manager);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + manager));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert data success : " + result));
        }
        return result;
    }

    public List<Manager> insertList(List<Manager> managerList) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert lists : " + (managerList == null ? "null" : Integer.valueOf(managerList.size()))));
        }
        List resultList = null;
        if (CollectionUtils.isEmpty(managerList)) {
            return new ArrayList<Manager>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Manager manager : managerList) {
            manager.setCreateAt(Long.valueOf(currentTimeMillis));
            manager.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(managerList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + managerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        }
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" delete data : " + id));
        }
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Manager.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" delete data success : " + id));
        }
        return result;
    }

    public boolean update(Manager manager) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (manager == null ? "null" : manager.getId())));
        boolean result = false;
        if (manager == null) {
            return true;
        }
        manager.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)manager);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + manager));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + manager));
        }
        return result;
    }

    public boolean updateList(List<Manager> managerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (managerList == null ? "null" : Integer.valueOf(managerList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(managerList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Manager manager : managerList) {
            manager.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(managerList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + managerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update lists success : " + managerList.size()));
        }
        return result;
    }

    public Manager getObjectById(Long id) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get data : " + id));
        }
        Manager manager = null;
        if (id == null) {
            return manager;
        }
        try {
            manager = (Manager)this.dao.get(Manager.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get data success : " + id));
        }
        return manager;
    }

    public List<Manager> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        }
        List manager = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Manager>();
        }
        try {
            manager = this.dao.getList(Manager.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get data success : " + (manager == null ? "null" : Integer.valueOf(manager.size()))));
        }
        return manager;
    }

    public List<Long> getManagerIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        List<Long> idList = new ArrayList<Long>();
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        if (name == null) {
            log.info((Object)"name is null ,so return direct ");
            return idList;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getManagerIdsByRoleID(Long roleID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by roleID,start,limit  : " + roleID + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsByRoleID", new Object[]{roleID}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + roleID + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getManagerIdsByRoleIDAndStatus(Long roleID, String status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by roleID,status,start,limit  : " + roleID + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsByRoleIDAndStatus", new Object[]{roleID, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + roleID + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getManagerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countManagerIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getManagerIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getManagerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getManagerIdsByCondition(Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        String sql = "select id from Manager where ";
        try {
            Set<String> fieldSet = conditions.keySet();
            for (String field : fieldSet) {
                sql = sql + field + "='" + conditions.get(field) + "'";
                sql = sql + " and ";
            }
            sql = sql.substring(0, sql.length() - " and ".length());
            sql = sql + " limit " + start + "," + limit;
            log.info((Object)("sql:" + sql));
            Object o = this.dao.excuteSimpleSql(sql, Manager.class);
            if (o instanceof List) {
                return (List)o;
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            BigInteger id = (BigInteger)o;
            ids.add(id.longValue());
            return ids;
        }
        catch (DaoException e) {
            log.error((Object)" count by getManagerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
    }
}

