package com.ptteng.course.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.learn.common.model.Message;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class
DynamicUtil {

        public static Map<String,Object> getMemberList(String name,String minPeriod,String maxPeriod,String minPrice,String maxPrice,Integer status,boolean count){
            Map<String,Object> params=new HashedMap();
            if (StringUtil.isNotEmpty(name)) {
                params.put("name & like", " '%" + name + "%'");
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                params.put("status", " '" + status + "'");
            }
            if (DataUtils.isNotNullOrEmpty(minPeriod)) {
                params.put("period+0 & >= ", " '" + minPeriod + "'");
            }
            if (DataUtils.isNotNullOrEmpty(maxPeriod)) {
                params.put("period+0 & <= ", " '" + maxPeriod + "'");
            }
            if (DataUtils.isNotNullOrEmpty(minPrice)) {
                params.put("price+0 & >= ", " '" + minPrice + "'");
            }
            if (DataUtils.isNotNullOrEmpty(maxPrice)) {
                params.put("price+0 & <= ", " '" + maxPrice + "'");
            }


            if(count){
                params.put("@query", " count(id)");

            }else {
                params.put("@order", "   period desc ");
                params.put("@query", " id");
            }


            params.put("@table", " member ");

            return params;
        }


        public static Map<String, Object> getVersionList(Integer type, String os, String version) {
        Map<String, Object> params = new HashedMap();

        params.put("type", type);
        params.put("img", " '" + os + "'");
        params.put("title &>", " '" + version + "'");
        params.put("@order", "  is_force_update desc ");
        params.put("@query", " id");
        params.put("@table", " article ");

        return params;
    }

    public static Map<String, Object> getLessonList(String name, Long subjectId, Integer level) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", "'" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", "'" + level + "'");
        }
        params.put("status", 1);
        params.put("@order", "  sort asc,update_at desc,level ");
        params.put("@query", " id");

        params.put("@table", " lesson ");

        return params;
    }


    public static Map<String, Object> getPeriodList(Integer level, String name, Long lessonId,
                                                    Long subjectId, Integer type, Long bookId, Long unitId) {
        Map<String, Object> params = new HashedMap();
        System.out.println(name + "name" + "lessonId" + lessonId + "subjectID" + subjectId + "type" + type);
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(lessonId)) {

            params.put("lesson_id", "'" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectId)) {

            params.put("subject_id", "'" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put("type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {

            params.put("level", "'" + level + "'");
        }
        if (DataUtils.isNotNullOrEmpty(bookId)) {

            params.put("book_id", "'" + bookId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(unitId)) {

            params.put("unit_id", "'" + unitId + "'");
        }
        params.put("status", 1);


        params.put("@order", "  sort ,level ");
        params.put("@query", " id ");

        params.put("@table", "  period ");

        return params;

    }


    public static Map<String, Object> getMessageList(Integer grade, String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type, Long userId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", " '%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(messageType)) {
            params.put("message_type", "'" + messageType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeLow)) {
            params.put("create_at&>", "'" + timeLow + "'");
        }

        if (DataUtils.isNotNullOrEmpty(type) && DataUtils.isNotNullOrEmpty(userId)) {
            if (type == 1) {
                if (grade == 7) {
                    params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + "))");

                } else {
                    params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + ") or  (type=1 and grade = " + grade + "))");

                    System.out.println(grade);
                }

            } else {
                params.put("type", "'" + type + "'");
            }
        }

        if (DataUtils.isNotNullOrEmpty(timeHigh)) {
            params.put("create_at&<", "'" + timeHigh + "'");
        }
        params.put("up_down", 1);
        if (Message.Type_Help.equals(type)) {
            params.put("@order", "  sort asc ");

        } else {
            params.put("@order", "  publish_at desc ");

        }
        params.put("@query", " id");

        params.put("@table", " message ");
        return params;
    }

    public static Map<String, Object> getPaperList(Long subjectId, Long lessonId, Long periodId, Long bookId, Integer level, Integer type) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", " '" + subjectId + "'");
        }

        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lesson_id", " '" + lessonId + "'");
        }


        if (DataUtils.isNotNullOrEmpty(bookId)) {
            params.put("book_id", " '" + bookId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", " '" + type + "'");
        }

        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("period_id", " '" + periodId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", " '" + level + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " paper.id");

        params.put("@table", " paper ");

        return params;
    }


    public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
                                                          Integer type, String title, String source, String status) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" update_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" update_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(source)) {
            params.put("source", " '" + source + "' ");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);

        }


        params.put("@order", " orderBy asc, create_at desc ");
        params.put("@query", " id ");

        params.put("@table", "  article ");

        return params;
    }


    public static Map<String, Object> getBannerListParam(Long createStart, Long createEnd,Long updateStart, Long updateEnd,
                                                         Integer type, String createBy, String title, String status) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");
        if (DataUtils.isNotNullOrEmpty(updateStart)) {
            params.put(" article.update_at & >= ", "'" + updateStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(updateEnd)) {
            params.put(" article.update_at & <= ", "'" + updateEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createStart)) {
            params.put(" article.create_at & >= ", "'" + createStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createEnd)) {
            params.put(" article.create_at & <= ", "'" + createEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" article.title & like", " '%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" article.type", type);
        }else {
            params.put("article.type & in ","(4,5,6,7,8)");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" article.status", status);

        }
        if(StringUtil.isNotEmpty(createBy)){
            params.put("manager.id ", "article.create_by");
            params.put(" manager.name & like ", "'%" + createBy + "'");
            tables.add("manager");
        }


        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);


        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getTaskList(Integer type, String name, Long subjectId, Long lessonId, Long periodId, Integer level, Integer status) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", " '" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", " '" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lesson_id", " '" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("period_id", " '" + periodId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", " '" + level + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "'");
        }
        params.put("@order", "  sort ,level ");
        params.put("@query", " id");

        params.put("@table", " task ");

        return params;
    }

    public static Map<String, Object> getUserMessageList(Long targetId, Long userId, Integer userRead) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(targetId)) {
            params.put("target_id", " '" + targetId + "'");
        }

        if (DataUtils.isNotNullOrEmpty(userId)) {
            params.put("user_id", " '" + userId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userRead)) {
            params.put("user_read", " '" + userRead + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " user_message_relation ");

        return params;
    }


    public static Map<String, Object> getBookList(String name, String press, Integer grade, Integer term, Long sid) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("statistics");
        if (name != null) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (grade != null) {
            params.put("grade", "'" + grade + "'");
        }
        if (press != null) {
            params.put("press", "'" + press + "'");
        }
        if (term != null) {
            params.put("term", term);
        }
        if (sid != null) {
            params.put("sid", sid);
        }
        params.put("status", 1);

        params.put("@order", " grade asc,press asc");

        params.put("@query", " id ");



        params.put("@table", " book");

        return params;

    }

    public static Map<String, Object> getUnitListByTaskIds(List<Long> taskIds,Long taskId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(taskIds)) {
            String ids=org.apache.commons.lang3.StringUtils.join(taskIds,",");
            params.put("task_id & in ", "(" + ids + ")");
        }
        if (DataUtils.isNotNullOrEmpty(taskId)) {
            params.put("task_id ", taskId);
        }
        params.put("@order", "  sort asc,update_at desc ");
        params.put("@query", " id");

        params.put("@table", " unit ");

        return params;
    }

    public static Map<String, Object> getAnswerListByTaskIds(List<Long> taskIds,Long taskId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(taskIds)) {
            String ids=org.apache.commons.lang3.StringUtils.join(taskIds,",");
            params.put("task_id & in ", "(" + ids + ")");
        }
        if (DataUtils.isNotNullOrEmpty(taskId)) {
            params.put("task_id ", taskId);
        }
        params.put("@order", " update_at desc ");
        params.put("@query", " id");

        params.put("@table", " answer ");

        return params;
    }

    public static Map<String, Object> getBookSubjectList(String name, Integer status) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("unit_name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        params.put("@order", "  sort asc,update_at desc ");
        params.put("@query", " id");

        params.put("@table", " book_subject ");

        return params;
    }


    public static Map<String, Object> getDictationWordsList(Long sid, Long uid) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("dictation_note");
        tables.add("dictation_words");
        if (sid != null) {
            params.put("dictation_note.sid", sid);
        }
        if (uid != null) {
            params.put("dictation_note.uid", uid);
        }
        params.put("dictation_note.id", "dictation_words.nid");

        params.put("@order", " dictation_words.create_at desc");

        params.put("@query", " dictation_words.id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getDictationWord(String img, String content, Integer type, Long uid, Long pid) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("dictation_note");
        tables.add("dictation_words");

        params.put("dictation_note.uid", uid);

        params.put("dictation_words.img", " '" + img + "'");

        params.put("dictation_words.pid", pid);

        params.put("dictation_words.content", " '" + content + "'");

        params.put("dictation_words.type", type);

        params.put("dictation_note.id", "dictation_words.nid");

        params.put("@query", " dictation_words.id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getGameScoreRank(Long uid, Long statisticsAt,Integer type,Integer mode,Long rank) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" user_id ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            if (type == 0) {
                params.put(" type & is ", "null");
            }else {
                params.put(" type ", type);
            }
        }
        if (DataUtils.isNotNullOrEmpty(statisticsAt)) {
            if (statisticsAt == 0) {
                params.put(" statistics_at & is ", "null");
            }else {
                params.put(" statistics_at ", statisticsAt);
            }
        }
        if (DataUtils.isNotNullOrEmpty(mode)) {
            if (mode == 0){
                params.put("mode & is ", "null");
            }else {
                params.put("mode", mode);
            }

        }
        if (DataUtils.isNotNullOrEmpty(rank)) {
            params.put("rank & <=", rank);
        }
        params.put("@order", " game_score desc ");
        params.put("@query", " id");

        params.put("@table", " game_score_rank ");

        return params;
    }

    public static Map<String, Object> getGameScoreRankByScoreNotZore(Long uid, Long statisticsAt,Integer type,Integer mode,Long rank) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" user_id ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            if (type == 0) {
                params.put(" type & is ", "null");
            }else {
                params.put(" type ", type);
            }
        }
        if (DataUtils.isNotNullOrEmpty(statisticsAt)) {
            if (statisticsAt == 0) {
                params.put(" statistics_at & is ", "null");
            }else {
                params.put(" statistics_at ", statisticsAt);
            }
        }
        if (DataUtils.isNotNullOrEmpty(mode)) {
            if (mode == 0){
                params.put("mode & is ", "null");
            }else {
                params.put("mode", mode);
            }

        }

        params.put("game_score & >", "0");

        if (DataUtils.isNotNullOrEmpty(rank)) {
            params.put("rank & <=", rank);
        }
        params.put("@order", " game_score desc ");
        params.put("@query", " id");

        params.put("@table", " game_score_rank ");

        return params;
    }
    public static Map<String, Object> getUserBestGameScore(Long uid,Integer type,Integer mode) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" user_id ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type ", type);
        }
        if (DataUtils.isNotNullOrEmpty(mode)) {
            params.put("mode", mode);
        }
        params.put("@query", " max(score) ");
        params.put("@table", " game_score_records ");

        return params;
    }
    public static Map<String, Object> getUserGameScoreIdsOrderByScore(Long uid,Integer type,Integer mode,Long score,boolean best) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" user_id ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type ", type);
        }
        if (DataUtils.isNotNullOrEmpty(score)) {
            params.put(" score ", score);
        }
        if (DataUtils.isNotNullOrEmpty(mode)) {
            params.put("mode", mode);
        }
        if (best){
            params.put(" best ","1");
        }
        params.put("@query", " id ");
        params.put("@order", " score desc");
        params.put("@table", " game_score_records ");

        return params;
    }
    public static Map<String, Object> getBestGameScoreRank(Long uid,Integer type,Integer mode,Integer typeBest) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" user_id ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type ", type);
        }

        if (DataUtils.isNotNullOrEmpty(mode)) {
            params.put("mode", mode);
        }
        if (DataUtils.isNotNullOrEmpty(typeBest)){
            params.put("type_best", typeBest);
        }
        params.put(" best ","1");
        params.put("@query", " id ");
        params.put("@order", " score desc");
        params.put("@table", " game_score_records ");

        return params;
    }

}
