package com.ptteng.course.home.controller;
import java.lang.invoke.ConstantCallSite;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.VersionIsForceUpdateCode;
import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.model.Version;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.admin.service.VersionService;
import com.ptteng.learn.course.model.Progress;
import com.ptteng.learn.course.service.ProgressService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * Progress  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SystemController {
	private static final Log log = LogFactory.getLog("system");

	@Autowired
	private VersionService versionService;

	private static final String OS = "os";

	private static final String VERSION = "version";
	
	
	@RequestMapping(value = "/test", method = RequestMethod.GET)
	public String getMultiProgressJson(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

		log.info("this is the demo web");

		return "/demo/link";
	}


	//我的信息
	@RequestMapping(value = "/a/version", method = RequestMethod.GET)
	public String allversion(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		log.info("version update control begin ==================");
		String os = request.getParameter(OS);
		String version = request.getParameter(VERSION);
		if (StringUtil.isEmpty(version)) {
			version = request.getHeader(VERSION);
		}
		if (StringUtil.isEmpty(os)) {
			os = request.getHeader(OS);
		}
		log.info("os = " + os + "     version = " + version);
		try {

			//参数校验
			if (StringUtil.isEmpty(os)) {
				log.info("arg os is empty and need force updating");
				model.addAttribute("code", 0);
				model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
				return "/learn-course-service/system/version";
			}
			if (StringUtil.isEmpty(version)) {
				log.info("arg version is empty need force updating");
				model.addAttribute("code", 0);
				model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
				return "/learn-course-service/system/version";
			}

			//获取最新版本
			log.info("get latestVersionInfo start ==========");
			List<Long> vidsByOs = versionService.getVersionIdsByOs(os, 0, Integer.MAX_VALUE);
			log.info(os +" all version  ids list  is  " + vidsByOs);
			List<Version> versionListByOs = versionService.getObjectsByIds(vidsByOs);

			Collections.sort(versionListByOs);
			List<Version> versionList = new ArrayList<>();
			model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.noNeedForceUpdate.getValue());
			for (Version systemVersion : versionListByOs) {
				switch (systemVersion.compareCode(systemVersion.getVersionCode(), version)) {
					case 1:
						versionList.add(systemVersion);
						if (systemVersion.getIsForceUpdate()) {
							log.info("need force updating");
							model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
						} else {
							log.info("version : " + systemVersion.getVersionCode() + " is a new version but not need tu force updating");
						}
						break;
					default:
						break;
				}
			}

			Version latestVersion = null;
			log.info("new version list is" + versionList);
			if (CollectionUtils.isEmpty(versionList)) {
				log.info("version is new and don't need force updating");
				model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.latestUpdateVersion.getValue());
			} else {
				log.info("version is not new but don't need force updating");
				latestVersion = versionList.get(0);
			}
			log.info("latest version is" + latestVersion);
			log.info("get latestVersionInfo finish ==========");

			model.addAttribute("code", 0);
			model.addAttribute("version", latestVersion);

		} catch (Throwable t) {
			log.error("VersionManager error...", t);
			model.put("code", -1);
		}
		log.info("version update control end ==================");
		return "/learn-course-service/system/version";
	}


	@RequestMapping(value = "/a/version/all", method = RequestMethod.GET)
	public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		HashMap<String, String> errorMap = new HashMap<String, String>();
		HashMap<String, Long> numMap = new HashMap<String, Long>();
		HashMap<String, Object> objMap = new HashMap<String, Object>();

		try {
			List<Long> andVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.os_android, 0, Integer.MAX_VALUE);
			log.info("android version id list : " + andVids);

			if(CollectionUtils.isNotEmpty(andVids)){

				List<Version> andVersions = versionService.getObjectsByIds(andVids);
				Collections.sort(andVersions);
				Version andVersion = andVersions.get(0);

				model.addAttribute("andVersion", andVersion);

			}else {
				log.info("no android version");
			}

			List<Long> iosVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.os_ios, 0, Integer.MAX_VALUE);
			log.info("ios version id list : " + iosVids);

			if(CollectionUtils.isNotEmpty(iosVids)){

				List<Version> iosVersions = versionService.getObjectsByIds(iosVids);
				Collections.sort(iosVersions);
				Version iosVersion = iosVersions.get(0);

				model.addAttribute("iosVersion", iosVersion);

			}else {
				log.info("no ios version");
			}

			model.addAttribute("code", 0);

		} catch (Exception e) {
			e.printStackTrace();
		}
		return "/learn-course-service/system/allversion";
	}


	
	
}

