package com.ptteng.course.home.controller;

import com.ptteng.learn.admin.model.Article;
import com.ptteng.learn.course.model.Member;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.model.UserOrder;
import com.ptteng.learn.course.model.UserRecommend;
import com.ptteng.learn.course.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Member  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MemberController {
    private static final Log log = LogFactory.getLog(MemberController.class);

    @Autowired
    private MemberService memberService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private UserRecommendService userRecommendService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;


    @RequestMapping(value = "/a/u/member/search", method = RequestMethod.GET)
    public String getMemberIdsByStatusJsonList(HttpServletRequest request,
                                               HttpServletResponse response, ModelMap model, Integer page,
                                               Integer size) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Boolean discountStatus = false;
            BigDecimal discount = BigDecimal.ZERO;
            Integer display = 0;

            //是否购买过会员
            List<Long> orderIds = userOrderService.getUserOrderIdsByUidAndBuyTypeAndStatus(uid, UserOrder.ORDER_MEMBER, UserOrder.COMPLETED, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(orderIds)) {
                log.info(" get user memberList ids ,size is 0 ");

                Long recommendId = user.getRecommendId();
                if(null == recommendId){
                    log.info("user have no recommend user ");
                }else {
                    log.info("recommend id is : " + recommendId);
                    discountStatus = true;
                    UserRecommend recommendUser = userRecommendService.getObjectById(recommendId);
                    discount = recommendUser.getDiscount();
                    display = recommendUser.getDisplay();
                }

            } else {
                log.info(" user almost buy member , no discount ");
            }

            List<Long> ids = memberService.getMemberIdsByStatus(Article.Status_Published, start, size);
            List<Member> memberList = new ArrayList<>();
            if (CollectionUtils.isEmpty(ids)) {
                log.info(" get memberList   ids ,size is 0 ");

            } else {
                log.info(" get memberList   ids ,size is  " + ids.size());
                memberList = memberService.getObjectsByIds(ids);
            }

            Integer total = memberService.countMemberIdsByStatus(Article.Status_Published);
            log.info("get member count is " + total);
            int totalPage = 1;
            if (null != total) {
                if (total > 0) {
                    totalPage = (((total - 1)) / (size)) + 1;
                    ;
                }
            }
            model.addAttribute("totalPage", totalPage);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);
            model.addAttribute("discountStatus", discountStatus);
            model.addAttribute("discount", discount);
            model.addAttribute("display", display);

            model.addAttribute("memberList", memberList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get member list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/member/json/memberListJson";
    }


    @RequestMapping(value = "/a/member/{id}", method = RequestMethod.GET)
    public String getMemberJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Member member = memberService.getObjectById(id);
            log.info("get member data is " + member);

            model.addAttribute("code", 0);

            model.addAttribute("member", member);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get member error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/member/json/memberDetailJson";
    }

    @RequestMapping(value = "/a/member/{id}", method = RequestMethod.PUT)
    public String updateMemberJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Member member) throws Exception {

        log.info("update member : member= " + member);

        try {

            memberService.update(member);

            model.addAttribute("code", 0);

            model.addAttribute("member", member);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update member error,id is  " + member.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/member", method = RequestMethod.POST)
    public String addMemberJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Member member) throws Exception {

        log.info("update member : member= " + member);

        try {
            member.setId(null);

            memberService.insert(member);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add member error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/member/{id}", method = RequestMethod.DELETE)
    public String deleteMemberJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete member : id= " + id);
        try {
            memberService.delete(id);

            log.info("add member success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete member error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/a/multi/member", method = RequestMethod.GET)
    public String getMultiMemberJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Member> memberList = memberService.getObjectsByIds(idList);
            log.info("get  member data is " + memberList);

            model.addAttribute("code", 0);
            model.addAttribute("total", memberList.size());

            model.addAttribute("memberList", memberList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get member error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/member/json/memberListJson";
    }


}

