package com.ptteng.course.home.controller;

import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.GameScoreRank;
import com.ptteng.learn.course.model.GameScoreRecords;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.GameScoreRankService;
import com.ptteng.learn.course.service.GameScoreRecordsService;
import com.ptteng.learn.course.service.UserService;
import com.ptteng.learn.course.vo.TimeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.Time;
import java.util.*;

/**
 * GameScoreRank  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class GameScoreRankController {
	private static final Log log = LogFactory.getLog(GameScoreRankController.class);

	@Autowired
	private GameScoreRankService gameScoreRankService;

	@Autowired
	private UserService userService;

	@Autowired
	private GameScoreRecordsService gameScoreRecordsService;


    /**
//	 *
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
//
//	@RequestMapping(value = "/c/gameScoreRank", method = RequestMethod.GET)
//	public String getgameScoreRankList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model) throws Exception {
//
//
//
//		log.info("/gameScoreRank  to /gameScoreRank/view/gameScoreRankList");
//
//		return "/learn-course-service/gameScoreRank/view/gameScoreRankList";
//	}
    
    

//
//
//		/**
//	 *
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
//
//
//		 @RequestMapping(value = "/c/gameScoreRank1 ", method = RequestMethod.GET)
//	public String getGameScoreRankIdsByUserIdOrderByCreateAtList1(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model,Long userId) throws Exception {
//
//		log.info("/gameScoreRank  to /gameScoreRank/view/gameScoreRankList");
//
//		return "/learn-course-service/gameScoreRank/view/gameScoreRankList";
//	}
//
//
	
	
//
//
//
//		/**
//	 *
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
//
//
//		 @RequestMapping(value = "/c/gameScoreRank2 ", method = RequestMethod.GET)
//	public String getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAtList2(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model,Long stasticsAt) throws Exception {
//
//		log.info("/gameScoreRank  to /gameScoreRank/view/gameScoreRankList");
//
//		return "/learn-course-service/gameScoreRank/view/gameScoreRankList";
//	}
//
//
//
//
//
//
	/**
	 * 获取用户游戏信息
	 * @return list；
	 * @throws Exception；
	 *
	 */
	@RequestMapping(value = "/a/game/user/{id}", method = RequestMethod.GET)
	public String getGameScoreRank(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id,Integer type,Integer mode)
			throws Exception {

		log.info("/a/game/user/" + id );
		if(null == id){
			model.addAttribute("code", -2013);
			return "/common/success";
		}

		User user = userService.getObjectById(id);

		if (user == null) {
			model.addAttribute("code", -2000);
			return "/common/success";
		}
		Integer typeBest = null;
		if (type == null) {
			typeBest = GameScoreRecords.Is_TypeBast_Score;
		}
		model.addAttribute("type",type);
		model.addAttribute("mode",mode);
		//获取最佳成绩
		Map<String,Object> bestParam =DynamicUtil.getBestGameScoreRank(id,type,mode,typeBest);
		List<Long> recordIds = gameScoreRecordsService.getIdsByDynamicCondition(GameScoreRecords.class,bestParam,0,1);
		if (recordIds.size()>0) {
			GameScoreRecords gameScoreRecords = gameScoreRecordsService.getObjectsByIds(recordIds).get(0);
			user.setBestResults(gameScoreRecords.getScore());
			log.info("get user best result success");
		}else {
			user.setBestResults(null);
			log.info(" user best result is null");
		}


		if (type == null) {
			type = GameScoreRank.UserRank_Type_Null;

		}
		if (mode == null) {
			mode = GameScoreRank.UserRank_Mode_Null;
		}
		//获取用户周排行
		Long statisticsAt = TimeUtil.getTimesWeekmorningInMillis();
		Map<String ,Object> param = DynamicUtil.getGameScoreRank(id,statisticsAt,type,mode,null);
		List<Long> ids = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param,0,1);
		GameScoreRank gameScoreRank = new GameScoreRank();
		if (ids.size()>0) {
			gameScoreRank = gameScoreRankService.getObjectsByIds(ids).get(0);
			user.setWeekRank(gameScoreRank.getRank());
			log.info("get user week rank success");
		}else {
			user.setWeekRank(null);
			log.info(" user week rank is null");
		}

		//总排行
		Map<String ,Object> param1 = DynamicUtil.getGameScoreRank(id,GameScoreRank.UserRank_NotWeek,type,mode,null);
		List<Long> ids1 = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param1,0,1);
		GameScoreRank gameScoreRank1 = new GameScoreRank();
		if (ids.size()>0) {
			gameScoreRank1 = gameScoreRankService.getObjectsByIds(ids1).get(0);
			user.setGameRank(gameScoreRank1.getRank());
			log.info("get user week rank success");
		}else {
			user.setGameRank(null);
			log.info(" user week rank is null");
		}



		model.addAttribute("code",0);

		model.addAttribute("user", user);


		return "/learn-course-service/gameScoreRank/json/userGameDetail";
	}

	
	
	    		
			
    /**
	 * 获取游戏积分排行
	 * @param top 游戏前Top名
	 * @param type 游戏类别
	 * @param mode 游戏模式
	 * @param rankType 榜单类型1总榜 2周榜
	 * @return list；
	 * @throws Exception；
	 *
	 */

		@RequestMapping(value = "/a/game/rank", method = RequestMethod.GET)
	public String getGameScoreRankIdsByUserIdOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long top,Integer type,Integer mode,Integer rankType,Long userId) throws Exception {
		log.info("api:/a/game/rank  top="+top+" type="+type+" mode="+mode+" rankType="+rankType +" userId="+userId);
		if (top == null) {
			top = 50L;
		}
		if (type == null) {
			type = GameScoreRank.UserRank_Type_Null;
		}
		if (mode == null) {
			mode = GameScoreRank.UserRank_Mode_Null;
		}
		Long statisticsAt = null;
		if (rankType == null) {
			model.addAttribute("code", -7008);
			return "/common/success";
		}else{
			switch (rankType) {
				case 1:
					statisticsAt = GameScoreRank.UserRank_NotWeek;
					break;
				case 2:
					statisticsAt = TimeUtil.getTimesWeekmorningInMillis();
			}
		}


		try {
			Map<String,Object> param = DynamicUtil.getGameScoreRank(userId,statisticsAt,type,mode,top);
			List<Long> ids = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param,0,Integer.MAX_VALUE);
			List<GameScoreRank> gameScoreRankList = gameScoreRankService.getObjectsByIds(ids);

			//设置用户信息
			List<Long> userIds = new ArrayList<>();
			for (GameScoreRank gameScoreRank:gameScoreRankList) {
				userIds.add(gameScoreRank.getUserId());
			}
			List<User> userList = userService.getObjectsByIds(userIds);
			Map<Long,User> users = new HashMap<>();
			for (User user: userList) {
				users.put(user.getId(),user);
			}

			for (GameScoreRank gameScoreRank:gameScoreRankList) {
				log.info("gameScoreRank userId is "+gameScoreRank.getUserId());
				gameScoreRank.setUserName(users.get(gameScoreRank.getUserId()).getNick());
			}
			Integer total = ids.size();



			model.addAttribute("code", 0);
			model.addAttribute("top", top);
			model.addAttribute("total", total);
			model.addAttribute("gameScoreRankList", gameScoreRankList);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRank list error");
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRank/json/gameScoreRankListJson";
	}

	/**
	 * 获取游戏最佳排行
	 * @param top 游戏前Top名
	 * @param type 游戏类别
	 * @param mode 游戏模式
	 * @param rankType 榜单类型1总榜 2周榜
	 * @return list；
	 * @throws Exception；
	 *
	 */

	@RequestMapping(value = "/a/game/rank/best", method = RequestMethod.GET)
	public String getGameScoreBestRankByUserIdOrderByCreateAtJsonList(HttpServletRequest request,
																	 HttpServletResponse response, ModelMap model, Integer top,Integer type,Integer mode,Integer rankType,Long userId) throws Exception {
		log.info("api:/a/game/rank/best  top="+top+" type="+type+" mode="+mode);
		if (top == null) {
			top = 50;
		}
		Integer typeBest = null;
		if (mode == null) {
			typeBest = GameScoreRecords.Is_TypeBast_Score;
		}

		if (type == null) {
			model.addAttribute("code", -7003);
			return "common/success";
		}

		try {

			Map<String ,Object> param = DynamicUtil.getBestGameScoreRank(userId,type,mode,typeBest);
			List<Long> ids = gameScoreRecordsService.getIdsByDynamicCondition(GameScoreRecords.class,param,0,top);
			log.info("best score ,type is " +type +" mode is "+mode + " ids is "+ids);
			List<GameScoreRecords> gameScoreRecordsList = gameScoreRecordsService.getObjectsByIds(ids);
			Long lastScore = 0L;
			Integer i = 0;
			List<Long> userIds = new ArrayList<>();
			for (GameScoreRecords gameScoreRecords:gameScoreRecordsList){
				userIds.add(gameScoreRecords.getUserId());
				if(gameScoreRecords.getScore().equals(lastScore)){
					gameScoreRecords.setRank(i);
				}else {
					i++;
					gameScoreRecords.setRank(i);
				}
				lastScore = gameScoreRecords.getScore();
			}

			//设置用户信息


			List<User> userList = userService.getObjectsByIds(userIds);
			Map<Long,User> users = new HashMap<>();
			for (User user: userList) {
				users.put(user.getId(),user);
			}

			for (GameScoreRecords gameScoreRecords:gameScoreRecordsList){
				gameScoreRecords.setUserName(users.get(gameScoreRecords.getUserId()).getNick());
			}

			model.addAttribute("code", 0);
			model.addAttribute("top", top);
//			model.addAttribute("total", total);
			model.addAttribute("gameScoreRecordsList", gameScoreRecordsList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRank list error");
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRecords/json/gameScoreRecordsListJson";
	}




//
//
//    /**
//	 * 获取本周积分排行
//	 * @param size 每页显示条数
//	 * @param page 页码
//	 * @return json
//	 * @throws Exception；
//	 */
//
//		@RequestMapping(value = "/a/game/rank/week ", method = RequestMethod.GET)
//	public String getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAtJsonList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Integer page,
//			Integer size,Long stasticsAt,Integer type) throws Exception {
//
//
////		if (page == null) {
////			page = 1;
////		}
////		if (size == null) {
////			size = 10;
////		}
////		int start = (page - 1) * size;
////		if (start < 0) {
////			start = 0;
////		}
////
////		log.info("pageList : page= " + start + " , size=" + size );
//
//		try {
//			stasticsAt = TimeUtil.getTimesWeekmorningInMillis();
//			List<Long> ids= gameScoreRankService.getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(stasticsAt,0,Integer.MAX_VALUE);
//			log.info("get countGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt size is " + ids.size());
//
//			List<GameScoreRank> gameScoreRankList = gameScoreRankService.getObjectsByIds(ids);
//			log.info("get gameScoreRank data is " + gameScoreRankList.size());
//
//			//获取用户信息
//			List<Long> userIds = new ArrayList<>();
//			for (GameScoreRank gameScoreRank:gameScoreRankList) {
//				 userIds.add(gameScoreRank.getUserId());
//			}
//			List<User> userList = userService.getObjectsByIds(userIds);
//			Map<Long,User> users = new HashMap<>();
//			for (User user: userList) {
//				users.put(user.getId(),user);
//			}
//
//			for (GameScoreRank gameScoreRank:gameScoreRankList) {
//				gameScoreRank.setUserName(users.get(gameScoreRank.getUserId()).getNick());
//			}
//
//
//
//
//			Integer total = gameScoreRankService. countGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(stasticsAt);
//			log.info("get gameScoreRank count is " + total);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("page", page);
//			model.addAttribute("size", size);
//
//			model.addAttribute("total", total);
//
//			model.addAttribute("gameScoreRankList", gameScoreRankList);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get gameScoreRank list error "
//					+ size);
//			// for test
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/gameScoreRank/json/gameScoreRankListJson";
//	}
//
//



	/**
	 * 获取用户本周积分排行
	 * @param id 用户id
	 * @return json
	 * @throws Exception；
	 */

	@RequestMapping(value = "/a/game/rank/week/{id}", method = RequestMethod.GET)
	public String getGameScoreRankJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id,Integer mode)
			throws Exception {

		log.info("get data : id= " + id);
		Long statisticsAt = TimeUtil.getTimesWeekmorningInMillis();
		try {
			User user = userService.getObjectById(id);
			if (user == null) {
				model.addAttribute("code", -2000);
				return "common/success";
			}

			Map<String,Object> param =  DynamicUtil.getGameScoreRank(id,statisticsAt,null,null,null);
			List<Long> ids = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param,0,Integer.MAX_VALUE);
			GameScoreRank gameScoreRank;
			if (ids.size() > 0) {
				gameScoreRank = gameScoreRankService.getObjectById(ids.get(0));
				gameScoreRank.setUserName(user.getNick());
			}else {
				model.addAttribute("code", -7004);
				return "common/success";
			}





			log.info("get gameScoreRank data is " + gameScoreRank);

			model.addAttribute("code", 0);

			model.addAttribute("gameScoreRank", gameScoreRank);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRank error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/gameScoreRank/json/gameScoreRankDetailJson";
	}

//	@RequestMapping(value = "/a/gameScoreRank/{id}", method = RequestMethod.PUT)
//	public String updateGameScoreRankJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, GameScoreRank gameScoreRank) throws Exception {
//
//		log.info("update gameScoreRank : gameScoreRank= " + gameScoreRank);
//
//		try {
//
//			gameScoreRankService.update(gameScoreRank);
//
//			model.addAttribute("code", 0);
//
//			model.addAttribute("gameScoreRank", gameScoreRank);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("update gameScoreRank error,id is  " + gameScoreRank.getId());
//			model.addAttribute("code", -6003);
//
//		}
//
//		return "/data/json";
//	}
//
//	@RequestMapping(value = "/a/gameScoreRank", method = RequestMethod.POST)
//	public String addGameScoreRankJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, GameScoreRank gameScoreRank) throws Exception {
//
//		log.info("update gameScoreRank : gameScoreRank= " + gameScoreRank);
//
//		try {
//			gameScoreRank.setId(null);
//
//			gameScoreRankService.insert(gameScoreRank);
//
//			model.addAttribute("code", 0);
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("add gameScoreRank error ");
//			model.addAttribute("code", -6002);
//		}
//
//		return "/data/json";
//	}

//	@RequestMapping(value = "/a/gameScoreRank/{id}", method = RequestMethod.DELETE)
//	public String deleteGameScoreRankJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
//			throws Exception {
//
//		log.info("delete gameScoreRank : id= " + id);
//		try {
//			gameScoreRankService.delete(id);
//
//			log.info("add gameScoreRank success");
//			model.addAttribute("code", 0);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("delete gameScoreRank error,id is  " + id);
//			model.addAttribute("code", -6004);
//
//		}
//
//		return "/data/json";
//	}

}

